/*
 * Decompiled with CFR 0.152.
 */
package singularity.events.server;

import lombok.NonNull;
import singularity.data.players.CosmicPlayer;
import singularity.events.server.LoginEvent;
import singularity.utils.MessageUtils;

public class LoginReceivedEvent
extends LoginEvent {
    private ConnectionResult result = new ConnectionResult();

    public LoginReceivedEvent(CosmicPlayer player) {
        super(player);
    }

    public void setResult(ConnectionResult result) {
        this.result = result;
    }

    public ConnectionResult getResult() {
        return this.result;
    }

    public static class ConnectionResult {
        private boolean cancelled = false;
        @NonNull
        private String disconnectMessage = "";

        public boolean validate() {
            if (this.isCancelled() && this.disconnectMessage.isEmpty()) {
                MessageUtils.logWarning("LoginReceivedEvent has an invalid ConnectionResult! This is due to being set to cancelled while the disconnectMessage is empty!");
                return false;
            }
            return true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        @NonNull
        public String getDisconnectMessage() {
            return this.disconnectMessage;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public void setDisconnectMessage(@NonNull String disconnectMessage) {
            if (disconnectMessage == null) {
                throw new NullPointerException("disconnectMessage is marked non-null but is null");
            }
            this.disconnectMessage = disconnectMessage;
        }
    }
}

