/*
 * Decompiled with CFR 0.152.
 */
package singularity.holders;

import gg.drak.thebase.objects.Identifiable;
import singularity.holders.CosmicHolder;
import singularity.holders.HolderInstantiator;
import singularity.holders.HoldersHolder;

public abstract class HolderInit<T extends CosmicHolder>
implements Identifiable {
    private String identifier;
    private boolean enabled;
    private T holder;

    public HolderInit(String identifier, HolderInstantiator<T> instantiator) {
        this.identifier = identifier;
        this.enabled = false;
        this.load();
        this.tryEnable(instantiator);
    }

    public void tryEnable(HolderInstantiator<T> instantiator) {
        try {
            this.holder = (CosmicHolder)instantiator.get();
            this.enabled = this.holder != null;
        }
        catch (Throwable e) {
            this.enabled = false;
            this.holder = null;
        }
    }

    public void load() {
        HoldersHolder.load(this);
        this.onLoad();
    }

    public abstract void onLoad();

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public T getHolder() {
        return this.holder;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHolder(T holder) {
        this.holder = holder;
    }
}

