/*
 * Decompiled with CFR 0.152.
 */
package singularity.objects;

import gg.drak.thebase.lib.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import singularity.data.uuid.UuidManager;
import singularity.objects.CosmicFavicon;

public class PingedResponse {
    private Protocol version;
    private Players players;
    private String description;
    @Nullable
    private CosmicFavicon favicon;
    private final ModInfo modinfo = new ModInfo();

    public PingedResponse(Protocol version, Players players, String description) throws IOException {
        this(version, players, description, (String)null);
    }

    public PingedResponse(Protocol version, Players players, String description, String favicon) throws IOException {
        this(version, players, description, favicon == null ? null : CosmicFavicon.createFromURL(favicon));
    }

    public PingedResponse(Protocol version, Players players, String description, CosmicFavicon favicon) {
        this.version = version;
        this.players = players;
        this.description = description;
        this.favicon = favicon;
    }

    public String getFaviconString() {
        return this.getFavicon() == null ? null : this.getFavicon().getEncoded();
    }

    public Protocol getVersion() {
        return this.version;
    }

    public void setVersion(Protocol version) {
        this.version = version;
    }

    public Players getPlayers() {
        return this.players;
    }

    public void setPlayers(Players players) {
        this.players = players;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CosmicFavicon getFavicon() {
        return this.favicon;
    }

    public void setFavicon(CosmicFavicon favicon) {
        this.favicon = favicon;
    }

    public static class Protocol {
        private String name;
        private int protocol;

        public String getName() {
            return this.name;
        }

        public int getProtocol() {
            return this.protocol;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setProtocol(int protocol) {
            this.protocol = protocol;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Protocol)) {
                return false;
            }
            Protocol other = (Protocol)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProtocol() != other.getProtocol()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Protocol;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProtocol();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "PingedResponse.Protocol(name=" + this.getName() + ", protocol=" + this.getProtocol() + ")";
        }

        public Protocol(String name, int protocol) {
            this.name = name;
            this.protocol = protocol;
        }
    }

    public static class Players {
        private int max;
        private int online;
        private PlayerInfo[] sample;

        public int getMax() {
            return this.max;
        }

        public int getOnline() {
            return this.online;
        }

        public PlayerInfo[] getSample() {
            return this.sample;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public void setOnline(int online) {
            this.online = online;
        }

        public void setSample(PlayerInfo[] sample) {
            this.sample = sample;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Players)) {
                return false;
            }
            Players other = (Players)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMax() != other.getMax()) {
                return false;
            }
            if (this.getOnline() != other.getOnline()) {
                return false;
            }
            return Arrays.deepEquals(this.getSample(), other.getSample());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Players;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMax();
            result = result * 59 + this.getOnline();
            result = result * 59 + Arrays.deepHashCode(this.getSample());
            return result;
        }

        public String toString() {
            return "PingedResponse.Players(max=" + this.getMax() + ", online=" + this.getOnline() + ", sample=" + Arrays.deepToString(this.getSample()) + ")";
        }

        public Players(int max, int online, PlayerInfo[] sample) {
            this.max = max;
            this.online = online;
            this.sample = sample;
        }
    }

    public static class ModInfo {
        private String type = "FML";
        private List<ModItem> modList = new ArrayList<ModItem>();

        public String getType() {
            return this.type;
        }

        public List<ModItem> getModList() {
            return this.modList;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setModList(List<ModItem> modList) {
            this.modList = modList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModInfo)) {
                return false;
            }
            ModInfo other = (ModInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<ModItem> this$modList = this.getModList();
            List<ModItem> other$modList = other.getModList();
            return !(this$modList == null ? other$modList != null : !((Object)this$modList).equals(other$modList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<ModItem> $modList = this.getModList();
            result = result * 59 + ($modList == null ? 43 : ((Object)$modList).hashCode());
            return result;
        }

        public String toString() {
            return "PingedResponse.ModInfo(type=" + this.getType() + ", modList=" + String.valueOf(this.getModList()) + ")";
        }
    }

    public static class ModItem {
        private String modid;
        private String version;

        public String getModid() {
            return this.modid;
        }

        public String getVersion() {
            return this.version;
        }

        public void setModid(String modid) {
            this.modid = modid;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModItem)) {
                return false;
            }
            ModItem other = (ModItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$modid = this.getModid();
            String other$modid = other.getModid();
            if (this$modid == null ? other$modid != null : !this$modid.equals(other$modid)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $modid = this.getModid();
            result = result * 59 + ($modid == null ? 43 : $modid.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "PingedResponse.ModItem(modid=" + this.getModid() + ", version=" + this.getVersion() + ")";
        }

        public ModItem(String modid, String version) {
            this.modid = modid;
            this.version = version;
        }
    }

    public static class PlayerInfo {
        private String name;
        private UUID uniqueId;
        private static final UUID md5UUID = UUID.fromString(UuidManager.makeDashedUUID("af74a02d19cb445bb07f6866a861f783"));

        public PlayerInfo(String name, String id) {
            this.setName(name);
            this.setId(id);
        }

        public void setId(String id) {
            try {
                this.uniqueId = UUID.fromString(UuidManager.makeDashedUUID(id));
            }
            catch (Exception e) {
                this.uniqueId = md5UUID;
            }
        }

        public String getId() {
            return this.uniqueId.toString().replace("-", "");
        }

        public String getName() {
            return this.name;
        }

        public UUID getUniqueId() {
            return this.uniqueId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUniqueId(UUID uniqueId) {
            this.uniqueId = uniqueId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerInfo)) {
                return false;
            }
            PlayerInfo other = (PlayerInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            UUID this$uniqueId = this.getUniqueId();
            UUID other$uniqueId = other.getUniqueId();
            return !(this$uniqueId == null ? other$uniqueId != null : !((Object)this$uniqueId).equals(other$uniqueId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlayerInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            UUID $uniqueId = this.getUniqueId();
            result = result * 59 + ($uniqueId == null ? 43 : ((Object)$uniqueId).hashCode());
            return result;
        }

        public String toString() {
            return "PingedResponse.PlayerInfo(name=" + this.getName() + ", uniqueId=" + String.valueOf(this.getUniqueId()) + ")";
        }

        public PlayerInfo(String name, UUID uniqueId) {
            this.name = name;
            this.uniqueId = uniqueId;
        }
    }
}

