/*
 * Decompiled with CFR 0.152.
 */
package singularity.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import singularity.utils.MessageUtils;

public class UUIDFetcher {
    private static final String API_URL = "https://playerdb.co/api/player/minecraft/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static UUID getUUID(@NotNull String name) {
        name = name.toLowerCase();
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpResponse<String> response;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL + name)).GET().build();
            try {
                response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    MessageUtils.logInfo("Failed to fetch UUID for username: " + name + ". HTTP status code: " + response.statusCode());
                    UUID uUID = null;
                    return uUID;
                }
            }
            catch (IOException | InterruptedException e) {
                MessageUtils.logInfo("Error fetching UUID for username: " + name + " - " + e.getMessage());
                UUID uUID = null;
                return uUID;
            }
            JsonElement parsed = JsonParser.parseString(response.body());
            if (parsed != null && parsed.isJsonObject()) {
                JsonObject data = parsed.getAsJsonObject();
                String uuid = data.get("data").getAsJsonObject().get("player").getAsJsonObject().get("username").getAsString();
                UUID uUID = UUID.fromString(uuid);
                return uUID;
            }
            MessageUtils.logInfo("Failed to parse JSON response for name: " + name);
            UUID uUID = null;
            return uUID;
        }
        catch (Exception exception) {
            MessageUtils.logInfo("Failed to get UUID for username: " + name);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getName(@NotNull String uuid) {
        uuid = uuid.toLowerCase();
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpResponse<String> response;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL + uuid)).GET().build();
            try {
                response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    MessageUtils.logInfo("Failed to fetch username for UUID: " + uuid + ". HTTP status code: " + response.statusCode());
                    String string = null;
                    return string;
                }
            }
            catch (IOException | InterruptedException e) {
                MessageUtils.logInfo("Error fetching username for UUID: " + uuid + " - " + e.getMessage());
                String string = null;
                return string;
            }
            StringReader stringReader = new StringReader(response.body());
            JsonReader jsonReader = new JsonReader(stringReader);
            JsonElement parsed = JsonParser.parseReader(jsonReader);
            if (parsed != null && parsed.isJsonObject()) {
                JsonObject data = parsed.getAsJsonObject();
                String string = data.get("data").getAsJsonObject().get("player").getAsJsonObject().get("username").getAsString();
                return string;
            }
            MessageUtils.logInfo("Failed to parse JSON response for UUID: " + uuid);
            String string = null;
            return string;
        }
        catch (Exception exception) {
            MessageUtils.logInfo("Failed to get name for UUID: " + uuid);
            return null;
        }
    }

    public static String getName(UUID uuid) {
        return UUIDFetcher.getName(uuid.toString());
    }
}

