/*
 * Decompiled with CFR 0.152.
 */
package singularity.utils;

import gg.drak.thebase.async.AsyncUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.configs.given.MainMessagesHandler;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.events.DeletePlayerEvent;
import singularity.data.players.events.DeleteSenderEvent;
import singularity.data.players.events.LoadPlayerEvent;
import singularity.data.players.events.LoadSenderEvent;
import singularity.data.players.events.UnloadPlayerEvent;
import singularity.data.players.events.UnloadSenderEvent;
import singularity.data.players.location.CosmicLocation;
import singularity.data.teleportation.TPTicket;
import singularity.data.uuid.UuidManager;
import singularity.modules.ModuleUtils;
import singularity.permissions.MetaValue;
import singularity.permissions.PermissionUtil;
import singularity.utils.MessageUtils;
import singularity.utils.UuidUtils;

public class UserUtils {
    private static ConcurrentSkipListMap<String, CosmicSender> loadedSenders = new ConcurrentSkipListMap();
    private static CosmicSender console;

    public static CosmicSender getConsole() {
        if (!UserUtils.hasConsole()) {
            UserUtils.loadConsole();
        }
        return console;
    }

    public static void ensureLoadedUsers() {
        if (UserUtils.getLoadedSenders() == null) {
            loadedSenders = new ConcurrentSkipListMap();
        }
        if (!UserUtils.hasConsole()) {
            UserUtils.loadConsole();
        }
        ConcurrentSkipListMap<String, CosmicPlayer> ensured = Singularity.getInstance().getUserManager().ensurePlayers();
        loadedSenders.putAll(ensured);
    }

    public static void loadConsole() {
        if (!UserUtils.hasConsole()) {
            console = UserUtils.createSender();
        }
    }

    public static boolean hasConsole() {
        return console != null;
    }

    public static ConcurrentSkipListMap<String, CosmicPlayer> getLoadedPlayers() {
        ConcurrentSkipListMap<String, CosmicPlayer> r = new ConcurrentSkipListMap<String, CosmicPlayer>();
        UserUtils.getLoadedSenders().forEach((s2, user) -> {
            if (user instanceof CosmicPlayer) {
                r.put((String)s2, (CosmicPlayer)user);
            }
        });
        return r;
    }

    public static ConcurrentSkipListSet<CosmicSender> getLoadedSendersSet() {
        ConcurrentSkipListSet<CosmicSender> r = new ConcurrentSkipListSet<CosmicSender>();
        UserUtils.getLoadedSenders().forEach((s2, user) -> {
            if (user != null) {
                r.add((CosmicSender)user);
            }
        });
        return r;
    }

    public static ConcurrentSkipListSet<CosmicPlayer> getLoadedPlayersSet() {
        ConcurrentSkipListSet<CosmicPlayer> r = new ConcurrentSkipListSet<CosmicPlayer>();
        UserUtils.getLoadedPlayers().forEach((s2, user) -> {
            if (user != null) {
                r.add((CosmicPlayer)user);
            }
        });
        return r;
    }

    public static CosmicSender loadSender(CosmicSender sender) {
        if (UserUtils.isLoaded(sender.getUuid())) {
            UserUtils.unloadSender(sender.getUuid());
        }
        UserUtils.getLoadedSenders().put(sender.getUuid(), sender);
        if (sender instanceof CosmicPlayer) {
            new LoadPlayerEvent((CosmicPlayer)sender).fire();
        } else {
            ModuleUtils.fireEvent(new LoadSenderEvent(sender));
        }
        return sender;
    }

    public static void unloadSender(CosmicSender user) {
        UserUtils.unloadSender(user.getUuid());
    }

    public static void saveSender(CosmicSender sender, boolean async) {
        if (sender == null) {
            return;
        }
        Singularity.getMainDatabase().saveSender(sender, async);
    }

    public static void unloadSender(String uuid) {
        CosmicSender sender = UserUtils.getLoadedSenders().remove(uuid);
        if (sender == null) {
            return;
        }
        if (sender instanceof CosmicPlayer) {
            new UnloadPlayerEvent((CosmicPlayer)sender).fire();
        } else {
            new UnloadSenderEvent(sender).fire();
        }
    }

    public static void deleteSender(String uuid) {
        CosmicSender sender = UserUtils.getOrGetSender(uuid).orElse(null);
        if (sender == null) {
            return;
        }
        AsyncUtils.executeAsync(() -> {
            Singularity.getMainDatabase().delete(uuid, false);
            if (sender instanceof CosmicPlayer) {
                new DeletePlayerEvent((CosmicPlayer)sender).fire();
            } else {
                new DeleteSenderEvent(sender).fire();
            }
        });
    }

    public static boolean isLoaded(String uuid) {
        return UserUtils.getSender(uuid).isPresent();
    }

    public static ConcurrentSkipListMap<String, CosmicSender> getOnlineSenders() {
        ConcurrentSkipListMap<String, CosmicSender> r = new ConcurrentSkipListMap<String, CosmicSender>();
        UserUtils.getLoadedSenders().forEach((s2, user) -> {
            if (user.isOnline()) {
                r.put(user.getUuid(), (CosmicSender)user);
            }
        });
        return r;
    }

    public static ConcurrentSkipListMap<String, CosmicPlayer> getOnlinePlayers() {
        ConcurrentSkipListMap<String, CosmicPlayer> r = new ConcurrentSkipListMap<String, CosmicPlayer>();
        UserUtils.getLoadedPlayers().forEach((s2, user) -> {
            if (user.isOnline()) {
                r.put(user.getUuid(), (CosmicPlayer)user);
            }
        });
        return r;
    }

    public static boolean userExists(String uuid) {
        return Singularity.getMainDatabase().exists(uuid).join();
    }

    public static Optional<CosmicSender> getSender(String uuid) {
        if (uuid == null) {
            return Optional.empty();
        }
        if (UuidUtils.isConsole(uuid)) {
            return Optional.of(UserUtils.getConsole());
        }
        CosmicSender sender = UserUtils.getLoadedSenders().get(uuid);
        if (sender == null) {
            return Optional.empty();
        }
        if (sender instanceof CosmicPlayer) {
            CosmicPlayer player = (CosmicPlayer)sender;
            return Optional.of(player);
        }
        return Optional.of(sender);
    }

    public static Optional<CosmicPlayer> getPlayer(String uuid) {
        Optional<CosmicSender> optional = UserUtils.getSender(uuid);
        if (optional.isPresent() && optional.get() instanceof CosmicPlayer) {
            return optional.map(s2 -> (CosmicPlayer)s2);
        }
        return Optional.empty();
    }

    public static CosmicPlayer loadPlayer(CosmicPlayer player) {
        return (CosmicPlayer)UserUtils.loadSender(player);
    }

    public static Optional<CosmicPlayer> getOrCreatePlayer(CosmicSender sender) {
        return UserUtils.getOrCreatePlayer(sender.getUuid());
    }

    public static CosmicSender createSender() {
        return new CosmicSender();
    }

    public static CosmicSender createSender(String uuid) {
        return new CosmicSender(uuid);
    }

    public static CosmicPlayer createPlayer(String uuid) {
        return new CosmicPlayer(uuid);
    }

    public static Optional<CosmicSender> getOrCreateSender(String uuid) {
        Optional<CosmicSender> optional = UserUtils.getOrGetSender(uuid);
        if (optional.isPresent()) {
            return optional;
        }
        if (UserUtils.isConsole(uuid)) {
            return Optional.ofNullable(UserUtils.getConsole());
        }
        if (!UuidUtils.isValidPlayerUUID(uuid)) {
            return Optional.empty();
        }
        CosmicPlayer player = UserUtils.createPlayer(uuid);
        player.load();
        player.augment((CompletableFuture)Singularity.getMainDatabase().loadPlayer(uuid), false);
        return Optional.of(player);
    }

    public static Optional<CosmicPlayer> getOrCreatePlayer(String uuid) {
        Optional<CosmicSender> sender = UserUtils.getOrCreateSender(uuid);
        if (sender.isPresent() && sender.get() instanceof CosmicPlayer) {
            return sender.map(s2 -> (CosmicPlayer)s2);
        }
        Optional<CosmicPlayer> optional = UserUtils.getOrGetPlayer(uuid);
        if (optional.isPresent()) {
            return optional;
        }
        if (!UuidUtils.isValidPlayerUUID(uuid)) {
            return Optional.empty();
        }
        CosmicPlayer player = UserUtils.createPlayer(uuid);
        player.load();
        player.augment((CompletableFuture)Singularity.getMainDatabase().loadPlayer(uuid), false);
        return Optional.of(player);
    }

    public static CosmicSender createTemporarySender(String uuid) {
        return new CosmicSender(uuid, true);
    }

    public static CosmicPlayer createTemporaryPlayer(String uuid) {
        return new CosmicPlayer(uuid, true);
    }

    public static Optional<CosmicSender> getOrGetSender(String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            return Optional.empty();
        }
        if (UuidUtils.isConsole(uuid)) {
            return Optional.of(UserUtils.getConsole());
        }
        Optional<CosmicSender> optional = UserUtils.getSender(uuid);
        if (optional.isPresent()) {
            return optional;
        }
        if (!UuidUtils.isValidPlayerUUID(uuid)) {
            return Optional.empty();
        }
        CosmicPlayer player = UserUtils.createTemporaryPlayer(uuid);
        player.load();
        player.augment((CompletableFuture)Singularity.getMainDatabase().loadPlayer(uuid), true);
        return Optional.of(player);
    }

    public static Optional<CosmicPlayer> getOrGetPlayer(String uuid) {
        Optional<CosmicSender> optional = UserUtils.getOrGetSender(uuid);
        if (optional.isPresent() && optional.get() instanceof CosmicPlayer) {
            return optional.map(s2 -> (CosmicPlayer)s2);
        }
        return Optional.empty();
    }

    public static boolean isConsole(String uuid) {
        if (UserUtils.getConsole() != null) {
            return UserUtils.getConsole().getIdentifier().equals(uuid);
        }
        return UuidUtils.isConsole(uuid);
    }

    public static String getOffOnFormatted(CosmicSender stat) {
        if (stat == null) {
            return MainMessagesHandler.MESSAGES.DEFAULTS.IS_NULL.get();
        }
        if (stat.isOnline()) {
            return MessageUtils.replaceAllPlayerBungee(stat, GivenConfigs.getMainConfig().playerOnlineName());
        }
        return MessageUtils.replaceAllPlayerBungee(stat, GivenConfigs.getMainConfig().playerOfflineName());
    }

    public static String getOffOnAbsolute(CosmicSender stat) {
        if (stat == null) {
            return MainMessagesHandler.MESSAGES.DEFAULTS.IS_NULL.get();
        }
        if (stat.isOnline()) {
            return MessageUtils.replaceAllPlayerBungee(stat, GivenConfigs.getMainConfig().playerOnlineName());
        }
        return MessageUtils.replaceAllPlayerBungee(stat, GivenConfigs.getMainConfig().playerOfflineName());
    }

    public static String getFormatted(CosmicSender stat) {
        if (stat == null) {
            return MainMessagesHandler.MESSAGES.DEFAULTS.IS_NULL.get();
        }
        return stat.getDisplayName();
    }

    public static String getAbsolute(CosmicSender stat) {
        if (stat == null) {
            return MainMessagesHandler.MESSAGES.DEFAULTS.IS_NULL.get();
        }
        return stat.getCurrentName();
    }

    public static String getPrefix(CosmicSender user) {
        if (!(user instanceof CosmicPlayer)) {
            return user.getMeta().getPrefix();
        }
        CosmicPlayer player = (CosmicPlayer)user;
        Optional<MetaValue> optional = PermissionUtil.getPrefix(player);
        if (optional.isEmpty()) {
            return user.getMeta().getPrefix();
        }
        return optional.get().getValue();
    }

    public static String getSuffix(CosmicSender user) {
        if (!(user instanceof CosmicPlayer)) {
            return user.getMeta().getSuffix();
        }
        CosmicPlayer player = (CosmicPlayer)user;
        Optional<MetaValue> optional = PermissionUtil.getSuffix(player);
        if (optional.isEmpty()) {
            return user.getMeta().getSuffix();
        }
        return optional.get().getValue();
    }

    public static String formatName(CosmicPlayer user) {
        return ModuleUtils.replacePlaceholders(user, user.getMeta().getFull());
    }

    public static String getFormattedDefaultNickname(CosmicPlayer user) {
        return ModuleUtils.replacePlaceholders(user, user.getMeta().getFull());
    }

    public static boolean runAs(CosmicSender user, String command) {
        try {
            user.runCommand(command);
            return true;
        }
        catch (Exception e) {
            MessageUtils.logWarning(e);
            return false;
        }
    }

    public static Optional<String> getUUIDFromName(String name) {
        return UuidManager.getUuidFromName(name);
    }

    public static Optional<CosmicSender> getOrGetSenderByName(String name) {
        Optional<String> uuid = UserUtils.getUUIDFromName(name);
        if (uuid.isEmpty()) {
            return Optional.empty();
        }
        return UserUtils.getOrGetSender(uuid.get());
    }

    public static Optional<CosmicPlayer> getOrGetPlayerByName(String name) {
        Optional<CosmicSender> sender = UserUtils.getOrGetSenderByName(name);
        if (sender.isEmpty()) {
            return Optional.empty();
        }
        if (sender.get() instanceof CosmicPlayer) {
            return Optional.of((CosmicPlayer)sender.get());
        }
        return Optional.empty();
    }

    public static Optional<CosmicSender> getOrCreateSenderByName(String name) {
        Optional<CosmicSender> optional = UserUtils.getOrGetSenderByName(name);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<String> uuid = UserUtils.getUUIDFromName(name);
        if (uuid.isEmpty()) {
            return Optional.empty();
        }
        CosmicSender sender = UserUtils.createSender(uuid.get());
        sender.load();
        sender.augment((CompletableFuture)Singularity.getMainDatabase().loadPlayer(uuid.get()), false);
        return Optional.of(sender);
    }

    public static Optional<CosmicPlayer> getOrCreatePlayerByName(String name) {
        Optional<CosmicPlayer> optional = UserUtils.getOrGetPlayerByName(name);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<String> uuid = UserUtils.getUUIDFromName(name);
        if (uuid.isEmpty()) {
            return Optional.empty();
        }
        CosmicPlayer player = UserUtils.createPlayer(uuid.get());
        player.load();
        player.augment((CompletableFuture)Singularity.getMainDatabase().loadPlayer(uuid.get()), false);
        return Optional.of(player);
    }

    public static CosmicPlayer getOrGetPlayerByNameNullable(String name) {
        return UserUtils.getOrGetPlayerByName(name).orElse(null);
    }

    public static CosmicSender getOrGetSenderByNameNullable(String name) {
        return UserUtils.getOrGetSenderByName(name).orElse(null);
    }

    public static CosmicPlayer getOrCreatePlayerByNameNullable(String name) {
        return UserUtils.getOrCreatePlayerByName(name).orElse(null);
    }

    public static CosmicSender getOrCreateSenderByNameNullable(String name) {
        return UserUtils.getOrCreateSenderByName(name).orElse(null);
    }

    public static ConcurrentSkipListSet<CosmicPlayer> getPlayersOn(String server) {
        ConcurrentSkipListSet<CosmicPlayer> r = new ConcurrentSkipListSet<CosmicPlayer>();
        UserUtils.getOnlinePlayers().forEach((s2, user) -> {
            if (user.getServer().getIdentifier().equals(server)) {
                r.add((CosmicPlayer)user);
            }
        });
        return r;
    }

    public static boolean isGeyserPlayer(CosmicPlayer user) {
        return UserUtils.isGeyserPlayer(user.getUuid());
    }

    public static boolean isGeyserPlayer(String uuid) {
        return uuid.startsWith("0000");
    }

    public static void syncAllUsers() {
        UserUtils.getLoadedSenders().forEach((s2, user) -> user.save());
    }

    public static void teleport(CosmicSender sender, CosmicPlayer target) {
        UserUtils.teleport(sender, target.getLocation());
    }

    public static void teleport(CosmicSender sender, CosmicLocation location) {
        if (sender.isConsole()) {
            MessageUtils.logWarning("Console attempted to teleport to " + location.asString());
            return;
        }
        TPTicket ticket = new TPTicket(sender.getIdentifier(), location);
        ticket.post();
    }

    public static ConcurrentSkipListMap<String, CosmicSender> getLoadedSenders() {
        return loadedSenders;
    }

    public static void setLoadedSenders(ConcurrentSkipListMap<String, CosmicSender> loadedSenders) {
        UserUtils.loadedSenders = loadedSenders;
    }

    public static void setConsole(CosmicSender console) {
        UserUtils.console = console;
    }
}

