/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.internal;

import de.leonhard.storage.internal.serialize.SimplixSerializerManager;
import de.leonhard.storage.internal.settings.DataType;
import de.leonhard.storage.shaded.jetbrains.annotations.NotNull;
import de.leonhard.storage.shaded.json.JSONObject;
import de.leonhard.storage.util.JsonUtils;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;

public class FileData {
    private final Map<String, Object> localMap;
    private final String rawPath;

    public FileData(DataType dataType, String pathPattern) {
        this.rawPath = pathPattern;
        this.localMap = dataType.getMapImplementation();
    }

    public FileData(Map<String, Object> map, DataType dataType, String pathPattern) {
        this.rawPath = pathPattern;
        this.localMap = dataType.getMapImplementation();
        this.localMap.putAll(map);
    }

    public FileData(Map<String, Object> map, DataType dataType) {
        this(map, dataType, ".");
    }

    public FileData(JSONObject jsonObject, String pathPattern) {
        this.rawPath = pathPattern;
        this.localMap = new HashMap<String, Object>(jsonObject.toMap());
    }

    public FileData(JSONObject jsonObject) {
        this(jsonObject, ".");
    }

    public FileData(JSONObject jsonObject, DataType dataType, String pathPattern) {
        this.rawPath = pathPattern;
        this.localMap = dataType.getMapImplementation();
        this.localMap.putAll(jsonObject.toMap());
    }

    public FileData(JSONObject jsonObject, DataType dataType) {
        this(jsonObject, dataType, ".");
    }

    public String[] splitPath(String path) {
        return path.split(Pattern.quote(this.rawPath));
    }

    public void clear() {
        this.localMap.clear();
    }

    public void loadData(Map<String, Object> map) {
        this.clear();
        if (map != null) {
            this.localMap.putAll(map);
        }
    }

    public Object get(String key) {
        String[] parts = this.splitPath(key);
        return this.get(this.localMap, parts, 0);
    }

    public Object get(String[] key) {
        return this.get(this.localMap, key, 0);
    }

    private Object get(Map<String, Object> map, String[] key, int id) {
        if (id < key.length - 1) {
            if (map.get(key[id]) instanceof Map) {
                Map tempMap = (Map)map.get(key[id]);
                return this.get(tempMap, key, id + 1);
            }
            return null;
        }
        return map.get(key[id]);
    }

    public synchronized void insert(String[] key, Object value) {
        this.localMap.put(key[0], this.localMap.containsKey(key[0]) && this.localMap.get(key[0]) instanceof Map ? this.insert((Map)this.localMap.get(key[0]), key, value, 1) : this.insert(this.createNewMap(), key, value, 1));
    }

    public synchronized void insert(String key, Object value) {
        this.insert(this.splitPath(key), value);
    }

    public synchronized <T> void insertSerializable(String[] key, T value, Class<T> type) {
        this.insert(key, SimplixSerializerManager.serialize(value, type));
    }

    public synchronized <T> void insertSerializable(String key, T value, Class<T> type) {
        this.insertSerializable(this.splitPath(key), value, type);
    }

    public synchronized <T> void insertSerializableList(String[] key, List<T> value, Class<T> type) {
        this.insert(key, SimplixSerializerManager.serializeList(value, type));
    }

    public synchronized <T> void insertSerializableList(String key, List<T> value, Class<T> type) {
        this.insertSerializableList(this.splitPath(key), value, type);
    }

    public synchronized <T> void insertSerializableMap(String[] key, Map<String, T> value, Class<T> type) {
        this.insert(key, SimplixSerializerManager.serializeMap(value, type));
    }

    public synchronized <T> void insertSerializableMap(String key, Map<String, T> value, Class<T> type) {
        this.insertSerializableMap(this.splitPath(key), value, type);
    }

    private Object insert(Map<String, Object> map, String[] key, Object value, int id) {
        if (id < key.length) {
            Map<String, Object> tempMap = this.createNewMap(map);
            Map childMap = map.containsKey(key[id]) && map.get(key[id]) instanceof Map ? (Map)map.get(key[id]) : this.createNewMap();
            tempMap.put(key[id], this.insert(childMap, key, value, id + 1));
            return tempMap;
        }
        return value;
    }

    public boolean containsKey(String key) {
        String[] parts = this.splitPath(key);
        return this.containsKey(this.localMap, parts, 0);
    }

    public boolean containsKey(String[] key) {
        return this.containsKey(this.localMap, key, 0);
    }

    private boolean containsKey(Map<String, Object> map, String[] key, int id) {
        if (id < key.length - 1) {
            if (map.containsKey(key[id]) && map.get(key[id]) instanceof Map) {
                Map tempMap = (Map)map.get(key[id]);
                return this.containsKey(tempMap, key, id + 1);
            }
            return false;
        }
        return map.containsKey(key[id]);
    }

    public synchronized void remove(String key) {
        if (this.containsKey(key)) {
            String[] parts = this.splitPath(key);
            this.removePr(parts);
        }
    }

    public synchronized void remove(String[] key) {
        if (this.containsKey(key)) {
            this.removePr(key);
        }
    }

    private void removePr(@NotNull String[] key) {
        if (key.length == 1) {
            this.localMap.remove(key[0]);
        } else {
            Object tempValue = this.localMap.get(key[0]);
            if (tempValue instanceof Map) {
                this.localMap.put(key[0], this.removePr((Map)tempValue, key, 1));
                if (((Map)this.localMap.get(key[0])).isEmpty()) {
                    this.localMap.remove(key[0]);
                }
            }
        }
    }

    private Map<String, Object> removePr(Map<String, Object> map, String[] key, int keyIndex) {
        if (keyIndex < key.length - 1) {
            Object tempValue = map.get(key[keyIndex]);
            if (tempValue instanceof Map) {
                map.put(key[keyIndex], this.removePr((Map)tempValue, key, keyIndex + 1));
                if (((Map)map.get(key[keyIndex])).isEmpty()) {
                    map.remove(key[keyIndex]);
                }
            }
        } else {
            map.remove(key[keyIndex]);
        }
        return map;
    }

    public Set<String> singleLayerKeySet() {
        return this.localMap.keySet();
    }

    public Set<String> singleLayerKeySet(String key) {
        return this.get(key) instanceof Map ? ((Map)this.get(key)).keySet() : new HashSet<String>();
    }

    public Set<String> singleLayerKeySet(String[] key) {
        return this.get(key) instanceof Map ? ((Map)this.get(key)).keySet() : new HashSet<String>();
    }

    public Set<String> keySet() {
        return this.multiLayerKeySet(this.localMap);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.multiLayerEntrySet(this.localMap);
    }

    public Set<Map.Entry<String, Object>> singleLayerEntrySet() {
        return this.localMap.entrySet();
    }

    public Set<String> keySet(String key) {
        return this.get(key) instanceof Map ? this.multiLayerKeySet((Map)this.get(key)) : new HashSet<String>();
    }

    public Set<String> keySet(String[] key) {
        return this.get(key) instanceof Map ? this.multiLayerKeySet((Map)this.get(key)) : new HashSet<String>();
    }

    private Set<String> multiLayerKeySet(Map<String, Object> map) {
        HashSet<String> out = new HashSet<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                for (String tempKey : this.multiLayerKeySet((Map)entry.getValue())) {
                    out.add(entry.getKey() + this.rawPath + tempKey);
                }
                continue;
            }
            out.add(entry.getKey());
        }
        return out;
    }

    private Set<Map.Entry<String, Object>> multiLayerEntrySet(Map<String, Object> map) {
        HashSet<Map.Entry<String, Object>> out = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (map.get(entry.getKey()) instanceof Map) {
                for (String tempKey : this.multiLayerKeySet((Map)map.get(entry.getKey()))) {
                    out.add(new AbstractMap.SimpleEntry<CallSite, Object>((CallSite)((Object)(entry.getKey() + this.rawPath + tempKey)), entry.getValue()));
                }
                continue;
            }
            out.add(entry);
        }
        return out;
    }

    public int singleLayerSize() {
        return this.localMap.size();
    }

    public int singleLayerSize(String key) {
        return this.get(key) instanceof Map ? ((Map)this.get(key)).size() : 0;
    }

    public int size() {
        return this.localMap.size();
    }

    public int size(String key) {
        Object o = this.get(key);
        if (o instanceof Map) {
            Map map = (Map)o;
            return this.size(map);
        }
        return 0;
    }

    public int size(String[] key) {
        Object o = this.get(key);
        if (o instanceof Map) {
            Map map = (Map)o;
            return this.size(map);
        }
        return 0;
    }

    public void putAll(Map<String, Object> map) {
        this.localMap.putAll(map);
    }

    public void putAllRaw(Map<String[], Object> map) {
        for (Map.Entry<String[], Object> entry : map.entrySet()) {
            this.insert(entry.getKey(), entry.getValue());
        }
    }

    private int size(Map<String, Object> map) {
        int size = map.size();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            size += this.size((Map)entry.getValue());
        }
        return size;
    }

    public Map<String, Object> toMap() {
        return Objects.requireNonNullElseGet(this.localMap, HashMap::new);
    }

    public JSONObject toJsonObject() {
        return JsonUtils.getJsonFromMap(this.localMap);
    }

    public boolean isSorted() {
        return this.localMap instanceof LinkedHashMap;
    }

    public Map<String, Object> createNewMap() {
        return this.isSorted() ? new LinkedHashMap() : new HashMap();
    }

    public Map<String, Object> createNewMap(Map<String, Object> value) {
        return this.isSorted() ? new LinkedHashMap<String, Object>(value) : new HashMap<String, Object>(value);
    }

    public int hashCode() {
        return this.localMap.hashCode();
    }

    public String toString() {
        return this.localMap.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileData fileData = (FileData)obj;
        return this.localMap.equals(fileData.localMap);
    }

    @Generated
    public String getRawPath() {
        return this.rawPath;
    }
}

