/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.internal.serialize;

import de.leonhard.storage.internal.serialize.SimplixSerializableLike;
import de.leonhard.storage.internal.serialize.SimplixSerializerHolder;
import de.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import de.leonhard.storage.util.Valid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class SimplixSerializerManager {
    private static final Map<Class<?>, SimplixSerializerHolder<?>> serializables = Collections.synchronizedMap(new HashMap());

    public static boolean isSerializable(Class<?> clazz) {
        return SimplixSerializerManager.findSerializable(clazz) != null;
    }

    public static void registerSerializable(@NonNull SimplixSerializerHolder<?> serializable) {
        if (serializable == null) {
            throw new NullPointerException("serializable is marked non-null but is null");
        }
        Valid.notNull(serializable.getClazz(), "Class of serializable mustn't be null");
        serializables.put(serializable.getClazz(), serializable);
    }

    @Nullable
    public static <T> SimplixSerializerHolder<T> findSerializable(Class<T> clazz) {
        SimplixSerializerHolder<?> s2 = serializables.get(clazz);
        if (s2.getClazz() == clazz) {
            return s2;
        }
        return null;
    }

    private static ClassCastException handleException(Exception e) {
        if (e instanceof ClassCastException) {
            return (ClassCastException)e;
        }
        ClassCastException ex = new ClassCastException(e.getClass().getCanonicalName() + ": " + e.getMessage());
        ex.addSuppressed(e);
        return ex;
    }

    public static <T> Object serialize(T obj) {
        SimplixSerializerHolder<?> serializable = SimplixSerializerManager.findSerializable(obj.getClass());
        Valid.notNull(serializable, "No serializable found for '" + obj.getClass().getSimpleName() + "'");
        try {
            return serializable.serialize(obj);
        }
        catch (Exception e) {
            throw SimplixSerializerManager.handleException(e);
        }
    }

    public static <T> Object serialize(T obj, Class<T> type) {
        SimplixSerializerHolder<T> serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'", "Raw: '" + obj.getClass().getSimpleName() + "'");
        try {
            return serializable.serialize(obj);
        }
        catch (Exception e) {
            throw SimplixSerializerManager.handleException(e);
        }
    }

    public static <T> T deserialize(Object raw, Object data, Class<T> type) {
        SimplixSerializerHolder<T> serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'", "Raw: '" + raw.getClass().getSimpleName() + "'");
        try {
            return serializable.deserialize(raw, data);
        }
        catch (Exception e) {
            throw SimplixSerializerManager.handleException(e);
        }
    }

    public static <T> T deserialize(Object raw, Class<T> type) {
        return SimplixSerializerManager.deserialize(raw, null, type);
    }

    public static <T> List<Object> serializeList(List<T> raw, Class<T> type) {
        SimplixSerializerHolder serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'");
        try {
            return raw.stream().map(o -> serializable.serialize(o)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw SimplixSerializerManager.handleException(e);
        }
    }

    public static <T> List<Object> serializeListFiltered(List<T> raw, Class<T> type) {
        SimplixSerializerHolder serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'");
        return raw.stream().map(o -> {
            try {
                return serializable.serialize(o);
            }
            catch (Throwable e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> List<T> deserializeList(List<?> raw, Object data, Class<T> type) {
        SimplixSerializerHolder serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'");
        try {
            return raw.stream().map(o -> serializable.deserialize(o, data)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw SimplixSerializerManager.handleException(e);
        }
    }

    public static <T> List<T> deserializeList(List<?> raw, Class<T> type) {
        return SimplixSerializerManager.deserializeList(raw, null, type);
    }

    public static <T> List<T> deserializeListFiltered(List<?> raw, Object data, Class<T> type) {
        SimplixSerializerHolder serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'");
        return raw.stream().map(o -> {
            try {
                return serializable.deserialize(o, data);
            }
            catch (Throwable e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> List<T> deserializeListFiltered(List<?> raw, Class<T> type) {
        return SimplixSerializerManager.deserializeListFiltered(raw, null, type);
    }

    public static <T> Map<String, Object> serializeMap(Map<String, T> map, Class<T> type) {
        SimplixSerializerHolder<T> serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'");
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        try {
            for (Map.Entry<String, T> e : map.entrySet()) {
                newMap.put(e.getKey(), serializable.serialize(e.getValue()));
            }
        }
        catch (Exception e) {
            throw SimplixSerializerManager.handleException(e);
        }
        return newMap;
    }

    public static <T> Map<String, Object> serializeMapFiltered(Map<String, T> map, Class<T> type) {
        SimplixSerializerHolder<T> serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'");
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<String, T> e : map.entrySet()) {
            try {
                newMap.put(e.getKey(), serializable.serialize(e.getValue()));
            }
            catch (Throwable throwable) {}
        }
        return newMap;
    }

    public static <T> Map<String, T> deserializeMap(Map<?, ?> raw, Object data, Class<T> type) {
        SimplixSerializerHolder<T> serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'");
        HashMap<String, T> map = new HashMap<String, T>();
        try {
            for (Map.Entry<?, ?> e : raw.entrySet()) {
                map.put((String)e.getKey(), serializable.deserialize(e.getValue(), data));
            }
        }
        catch (Exception e) {
            throw SimplixSerializerManager.handleException(e);
        }
        return map;
    }

    public static <T> Map<String, T> deserializeMap(Map<?, ?> raw, Class<T> type) {
        return SimplixSerializerManager.deserializeMap(raw, null, type);
    }

    public static <T> Map<String, T> deserializeMapFiltered(Map<?, ?> raw, Object data, Class<T> type) {
        SimplixSerializerHolder<T> serializable = SimplixSerializerManager.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'");
        HashMap<String, T> map = new HashMap<String, T>();
        for (Map.Entry<?, ?> e : raw.entrySet()) {
            try {
                map.put((String)e.getKey(), serializable.deserialize(e.getValue(), data));
            }
            catch (Throwable throwable) {}
        }
        return map;
    }

    public static <T> Map<String, T> deserializeMapFiltered(Map<?, ?> raw, Class<T> type) {
        return SimplixSerializerManager.deserializeMapFiltered(raw, null, type);
    }

    public static Map<String, ?> resolveMapSingle(Map<String, ?> map) {
        HashMap<String, Object> sub = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            sub.put(entry.getKey(), SimplixSerializerManager.resolveSingle(entry.getValue()));
        }
        return sub;
    }

    public static Map<String, ?> resolveMapAll(Map<String, ?> map) {
        HashMap<String, Object> sub = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            sub.put(entry.getKey(), SimplixSerializerManager.resolveSingle(entry.getValue()));
        }
        return sub;
    }

    public static List<?> resolveListSingle(List<?> list) {
        ArrayList<Object> sub = new ArrayList<Object>();
        for (Object o : list) {
            sub.add(SimplixSerializerManager.resolveSingle(o));
        }
        return sub;
    }

    public static List<?> resolveListAll(List<?> list) {
        ArrayList<Object> sub = new ArrayList<Object>();
        for (Object o : list) {
            sub.add(SimplixSerializerManager.resolveSingle(o));
        }
        return sub;
    }

    public static Object resolveSingle(Object o) {
        if (o instanceof SimplixSerializableLike) {
            SimplixSerializableLike s2 = (SimplixSerializableLike)o;
            return s2.serialized();
        }
        if (o instanceof Iterable) {
            Iterable i2 = (Iterable)o;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object s3 : i2) {
                list.add(SimplixSerializerManager.resolveSingle(s3));
            }
            return list;
        }
        if (o instanceof Map) {
            Map m4;
            Map subMap = m4 = (Map)o;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry entry : subMap.entrySet()) {
                map.put((String)entry.getKey(), SimplixSerializerManager.resolveSingle(entry.getValue()));
            }
            return map;
        }
        return o;
    }

    public static Object resolveAll(Object o) {
        if (o instanceof SimplixSerializableLike) {
            SimplixSerializableLike s2 = (SimplixSerializableLike)o;
            return SimplixSerializerManager.resolveAll(s2.serialized());
        }
        if (o instanceof Iterable) {
            Iterable i2 = (Iterable)o;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object s3 : i2) {
                list.add(SimplixSerializerManager.resolveAll(s3));
            }
            return list;
        }
        if (o instanceof Map) {
            Map m4;
            Map subMap = m4 = (Map)o;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry entry : subMap.entrySet()) {
                map.put((String)entry.getKey(), SimplixSerializerManager.resolveAll(entry.getValue()));
            }
            return map;
        }
        return o;
    }

    @Generated
    private SimplixSerializerManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

