/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.async;

import gg.drak.thebase.async.AsyncTask;
import gg.drak.thebase.async.ThreadHolder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;

public class AsyncUtils {
    private static AtomicLong currentTaskId = new AtomicLong(0L);
    private static ConcurrentSkipListSet<AsyncTask> queuedTasks = new ConcurrentSkipListSet();

    public static void init() {
    }

    public static long queueTask(AsyncTask task) {
        queuedTasks.add(task);
        return task.getId();
    }

    public static void removeTask(long taskId) {
        queuedTasks.removeIf(task -> task.getId() == taskId);
    }

    public static void removeTask(AsyncTask task) {
        AsyncUtils.removeTask(task.getId());
    }

    public static Optional<AsyncTask> getTask(long taskId) {
        return queuedTasks.stream().filter(task -> task.getId() == taskId).findFirst();
    }

    public static long getNextTaskId() {
        return AsyncUtils.getCurrentTaskId().getAndIncrement();
    }

    public static void tickTasks() {
        AsyncUtils.getQueuedTasks().forEach(AsyncTask::tick);
    }

    public static <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier);
    }

    public static long runAsync(Runnable runnable, long delay) {
        return new AsyncTask(asyncTask -> runnable.run(), delay).queue();
    }

    public static long runAsync(Consumer<AsyncTask> consumer, long delay) {
        return new AsyncTask(consumer, delay).queue();
    }

    public static long runAsync(Runnable runnable, long delay, long period) {
        return new AsyncTask(asyncTask -> runnable.run(), delay, period).queue();
    }

    public static long runAsync(Consumer<AsyncTask> consumer, long delay, long period) {
        return new AsyncTask(consumer, delay, period).queue();
    }

    public static CompletableFuture<Void> runSync(Runnable runnable, long delay) {
        return ThreadHolder.with(runnable, delay);
    }

    public static CompletableFuture<Void> runSync(Runnable runnable, long delay, long period) {
        return ThreadHolder.with(runnable, delay, period);
    }

    public static long convertToMilliseconds(long ticks) {
        return ticks * AsyncUtils.getMillisInATick();
    }

    public static long convertToTicks(long milliseconds) {
        return milliseconds / AsyncUtils.getMillisInATick();
    }

    public static long getMillisInATick() {
        return 50L;
    }

    public static CompletableFuture<Void> executeAsync(Runnable runnable) {
        return CompletableFuture.runAsync(runnable);
    }

    public static CompletableFuture<Void> executeSync(Runnable runnable) {
        return ThreadHolder.with(runnable);
    }

    public static void executeThreaded(Runnable runnable) {
        CompletableFuture.runAsync(runnable).join();
    }

    public static void cancelTask(long taskId) {
        AsyncUtils.getTask(taskId).ifPresent(AsyncTask::remove);
    }

    @Generated
    public static AtomicLong getCurrentTaskId() {
        return currentTaskId;
    }

    @Generated
    public static void setCurrentTaskId(AtomicLong currentTaskId) {
        AsyncUtils.currentTaskId = currentTaskId;
    }

    @Generated
    public static ConcurrentSkipListSet<AsyncTask> getQueuedTasks() {
        return queuedTasks;
    }

    @Generated
    public static void setQueuedTasks(ConcurrentSkipListSet<AsyncTask> queuedTasks) {
        AsyncUtils.queuedTasks = queuedTasks;
    }
}

