/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.async;

import gg.drak.thebase.async.SyncInstance;
import gg.drak.thebase.async.SyncTask;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import lombok.Generated;

public class ThreadHolder {
    private static ConcurrentSkipListSet<SyncInstance> loadedSyncInstances = new ConcurrentSkipListSet();

    public static void register(SyncInstance syncInstance) {
        ThreadHolder.unregister(syncInstance);
        ThreadHolder.getLoadedSyncInstances().add(syncInstance);
    }

    public static void unregister(String identifier) {
        ThreadHolder.getLoadedSyncInstances().removeIf(syncInstance -> syncInstance.getIdentifier().equals(identifier));
    }

    public static void unregister(SyncInstance syncInstance) {
        ThreadHolder.unregister(syncInstance.getIdentifier());
    }

    public static Optional<SyncInstance> get(String identifier) {
        return ThreadHolder.getLoadedSyncInstances().stream().filter(syncInstance -> syncInstance.getIdentifier().equals(identifier)).findFirst();
    }

    public static Optional<SyncInstance> get(SyncInstance syncInstance) {
        return ThreadHolder.get(syncInstance.getIdentifier());
    }

    public static boolean isRegistered(String identifier) {
        return ThreadHolder.get(identifier).isPresent();
    }

    public static boolean isRegistered(SyncInstance syncInstance) {
        return ThreadHolder.isRegistered(syncInstance.getIdentifier());
    }

    public static Optional<SyncInstance> getFirst() {
        return ThreadHolder.getLoadedSyncInstances().stream().findFirst();
    }

    public static Consumer<SyncTask> convert(Runnable runnable) {
        return task -> runnable.run();
    }

    public static CompletableFuture<Void> with(SyncInstance instance, SyncTask task) {
        long delay = task.getDelay();
        long period = task.getPeriod();
        if (period != -1L && delay != -1L) {
            return instance.runSync(task::runThreaded, delay, period);
        }
        if (period == -1L && delay != -1L) {
            return instance.runSync(task::runThreaded, delay);
        }
        return instance.executeSync(task::runThreaded);
    }

    public static CompletableFuture<Void> with(String identifier, SyncTask task) {
        Optional<SyncInstance> optional = ThreadHolder.get(identifier);
        if (optional.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return ThreadHolder.with(optional.get(), task);
    }

    public static CompletableFuture<Void> with(String identifier, Runnable runnable) {
        return ThreadHolder.with(identifier, new SyncTask(ThreadHolder.convert(runnable)));
    }

    public static CompletableFuture<Void> with(String identifier, Runnable runnable, long delay) {
        return ThreadHolder.with(identifier, new SyncTask(ThreadHolder.convert(runnable), delay));
    }

    public static CompletableFuture<Void> with(String identifier, Runnable runnable, long delay, long period) {
        return ThreadHolder.with(identifier, new SyncTask(ThreadHolder.convert(runnable), delay, period));
    }

    public static CompletableFuture<Void> with(SyncTask task) {
        Optional<SyncInstance> optional = ThreadHolder.getFirst();
        if (optional.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return ThreadHolder.with(optional.get(), task);
    }

    public static CompletableFuture<Void> with(Runnable runnable) {
        return ThreadHolder.with(new SyncTask(ThreadHolder.convert(runnable)));
    }

    public static CompletableFuture<Void> with(Runnable runnable, long delay) {
        return ThreadHolder.with(new SyncTask(ThreadHolder.convert(runnable), delay));
    }

    public static CompletableFuture<Void> with(Runnable runnable, long delay, long period) {
        return ThreadHolder.with(new SyncTask(ThreadHolder.convert(runnable), delay, period));
    }

    @Generated
    public static ConcurrentSkipListSet<SyncInstance> getLoadedSyncInstances() {
        return loadedSyncInstances;
    }

    @Generated
    public static void setLoadedSyncInstances(ConcurrentSkipListSet<SyncInstance> loadedSyncInstances) {
        ThreadHolder.loadedSyncInstances = loadedSyncInstances;
    }
}

