/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.events;

import gg.drak.thebase.events.BaseEventHandler;
import gg.drak.thebase.events.BaseEventListener;
import gg.drak.thebase.events.RegisteredListener;
import gg.drak.thebase.events.components.BaseEvent;
import gg.drak.thebase.events.processing.BaseEventExecutor;
import gg.drak.thebase.events.processing.BaseProcessor;
import gg.drak.thebase.events.processing.exception.BaseEventException;
import gg.drak.thebase.objects.handling.IEventable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import lombok.Generated;

public class BaseListenerLayout {
    private int index;
    private List<Method> methods = new ArrayList<Method>();
    private BaseEventListener listener;

    public BaseListenerLayout(BaseEventListener listener) {
        this.setListener(listener);
        this.setIndex(BaseEventHandler.getListeners().size());
        BaseEventHandler.getListeners().put(this.getIndex(), this.getListener());
        this.setMethods(new ArrayList<Method>(this.getConcurrentMethods().values()));
    }

    public BaseListenerLayout(List<Method> methods) {
        this.setListener(this.listener);
        this.setIndex(BaseEventHandler.getListeners().size());
        BaseEventHandler.getListeners().put(this.getIndex(), this.getListener());
        this.setMethods(methods);
    }

    public ConcurrentSkipListMap<String, Method> getConcurrentMethods() {
        ConcurrentSkipListMap<String, Method> r = new ConcurrentSkipListMap<String, Method>();
        for (Method method : this.getListener().getClass().getMethods()) {
            r.put(method.getName(), method);
        }
        for (Method method : this.getListener().getClass().getDeclaredMethods()) {
            r.put(method.getName(), method);
        }
        return r;
    }

    public ConcurrentHashMap<Class<? extends BaseEvent>, ConcurrentSkipListSet<RegisteredListener<?>>> setUp(IEventable eventable) {
        ConcurrentHashMap ret = new ConcurrentHashMap();
        for (Method method : this.getMethods()) {
            Class<?> checkClass;
            BaseProcessor eh = method.getAnnotation(BaseProcessor.class);
            if (eh == null || method.isBridge() || method.isSynthetic() || method.getParameterTypes().length != 1 || !BaseEvent.class.isAssignableFrom(checkClass = method.getParameterTypes()[0])) continue;
            Class<BaseEvent> eventClass = checkClass.asSubclass(BaseEvent.class);
            method.setAccessible(true);
            ConcurrentSkipListSet eventSet = ret.computeIfAbsent(eventClass, k -> new ConcurrentSkipListSet());
            Class<BaseEvent> clazz = eventClass;
            while (BaseEvent.class.isAssignableFrom(clazz) && clazz.getAnnotation(Deprecated.class) == null) {
                clazz = clazz.getSuperclass();
            }
            BaseEventExecutor executor = (listener1, event) -> {
                try {
                    if (!eventClass.isAssignableFrom(event.getClass())) {
                        return;
                    }
                    method.invoke((Object)listener1, event);
                }
                catch (InvocationTargetException ex) {
                    throw new BaseEventException(ex.getCause());
                }
                catch (Throwable t2) {
                    throw new BaseEventException(t2);
                }
                event.setCompleted(true);
            };
            eventSet.add(new RegisteredListener<IEventable>(this.getListener(), executor, eh.priority(), eventable, eh.ignoreCancelled()));
        }
        return ret;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public List<Method> getMethods() {
        return this.methods;
    }

    @Generated
    public void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    @Generated
    public BaseEventListener getListener() {
        return this.listener;
    }

    @Generated
    public void setListener(BaseEventListener listener) {
        this.listener = listener;
    }
}

