/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.document;

import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.YamlConfig;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.YamlException;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.document.YamlDocument;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.document.YamlElement;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.document.YamlEntry;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.document.YamlScalar;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.emitter.Emitter;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.emitter.EmitterException;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.parser.Event;
import gg.drak.thebase.lib.leonhard.storage.shaded.esotericsoftware.yamlbeans.parser.MappingStartEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlMapping
extends YamlElement
implements YamlDocument {
    List<YamlEntry> entries = new LinkedList<YamlEntry>();

    @Override
    public int size() {
        return this.entries.size();
    }

    public void addEntry(YamlEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public boolean deleteEntry(String key) {
        for (int index = 0; index < this.entries.size(); ++index) {
            if (!key.equals(this.entries.get(index).getKey().getValue())) continue;
            this.entries.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public YamlEntry getEntry(String key) throws YamlException {
        for (YamlEntry entry : this.entries) {
            if (!key.equals(entry.getKey().getValue())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public YamlEntry getEntry(int index) throws YamlException {
        return this.entries.get(index);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.anchor != null) {
            sb.append('&');
            sb.append(this.anchor);
            sb.append(' ');
        }
        if (this.tag != null) {
            sb.append(" !");
            sb.append(this.tag);
        }
        if (!this.entries.isEmpty()) {
            sb.append('{');
            for (YamlEntry entry : this.entries) {
                sb.append(entry.toString());
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            sb.append('}');
        }
        return sb.toString();
    }

    @Override
    public void emitEvent(Emitter emitter, YamlConfig.WriteConfig config) throws EmitterException, IOException {
        emitter.emit(new MappingStartEvent(this.anchor, this.tag, this.tag == null, config.isFlowStyle()));
        for (YamlEntry entry : this.entries) {
            entry.emitEvent(emitter, config);
        }
        emitter.emit(Event.MAPPING_END);
    }

    @Override
    public void setEntry(String key, boolean value) throws YamlException {
        this.setEntry(key, new YamlScalar(value));
    }

    @Override
    public void setEntry(String key, Number value) throws YamlException {
        this.setEntry(key, new YamlScalar(value));
    }

    @Override
    public void setEntry(String key, String value) throws YamlException {
        this.setEntry(key, new YamlScalar(value));
    }

    @Override
    public void setEntry(String key, YamlElement value) throws YamlException {
        YamlEntry entry = this.getEntry(key);
        if (entry != null) {
            entry.setValue(value);
        } else {
            entry = new YamlEntry(new YamlScalar(key), value);
            this.addEntry(entry);
        }
    }

    @Override
    public YamlElement getElement(int item) throws YamlException {
        throw new YamlException("Can only get element on sequence!");
    }

    @Override
    public void deleteElement(int element) throws YamlException {
        throw new YamlException("Can only delete element on sequence!");
    }

    @Override
    public void setElement(int item, boolean element) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    @Override
    public void setElement(int item, Number element) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    @Override
    public void setElement(int item, String element) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    @Override
    public void setElement(int item, YamlElement element) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    @Override
    public void addElement(boolean element) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    @Override
    public void addElement(Number element) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    @Override
    public void addElement(String element) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    @Override
    public void addElement(YamlElement element) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    @Override
    public Iterator<YamlEntry> iterator() {
        return this.entries.iterator();
    }
}

