/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj.protocol.a;

import gg.drak.thebase.lib.mysql.cj.exceptions.ExceptionFactory;
import gg.drak.thebase.lib.mysql.cj.exceptions.WrongArgumentException;
import gg.drak.thebase.lib.mysql.cj.protocol.ColumnDefinition;
import gg.drak.thebase.lib.mysql.cj.protocol.ProtocolEntityFactory;
import gg.drak.thebase.lib.mysql.cj.protocol.a.ColumnDefinitionFactory;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativePacketPayload;
import gg.drak.thebase.lib.mysql.cj.result.DefaultColumnDefinition;
import gg.drak.thebase.lib.mysql.cj.result.Field;

public class MergingColumnDefinitionFactory
extends ColumnDefinitionFactory
implements ProtocolEntityFactory<ColumnDefinition, NativePacketPayload> {
    public MergingColumnDefinitionFactory(long columnCount, ColumnDefinition columnDefinitionFromCache) {
        super(columnCount, columnDefinitionFromCache);
    }

    @Override
    public boolean mergeColumnDefinitions() {
        return true;
    }

    @Override
    public ColumnDefinition createFromFields(Field[] fields) {
        if (this.columnDefinitionFromCache != null) {
            if ((long)fields.length != this.columnCount) {
                throw ExceptionFactory.createException(WrongArgumentException.class, "Wrong number of ColumnDefinition fields.");
            }
            Field[] f = this.columnDefinitionFromCache.getFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                fields[i2].setFlags(f[i2].getFlags());
            }
        }
        return new DefaultColumnDefinition(fields);
    }
}

