/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj.protocol.a;

import gg.drak.thebase.lib.mysql.cj.conf.PropertyKey;
import gg.drak.thebase.lib.mysql.cj.protocol.ColumnDefinition;
import gg.drak.thebase.lib.mysql.cj.protocol.ProtocolEntityFactory;
import gg.drak.thebase.lib.mysql.cj.protocol.Resultset;
import gg.drak.thebase.lib.mysql.cj.protocol.ResultsetRow;
import gg.drak.thebase.lib.mysql.cj.protocol.a.AbstractRowFactory;
import gg.drak.thebase.lib.mysql.cj.protocol.a.MysqlTextValueDecoder;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativeConstants;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativePacketPayload;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativeProtocol;
import gg.drak.thebase.lib.mysql.cj.protocol.a.result.ByteArrayRow;
import gg.drak.thebase.lib.mysql.cj.protocol.a.result.TextBufferRow;

public class TextRowFactory
extends AbstractRowFactory
implements ProtocolEntityFactory<ResultsetRow, NativePacketPayload> {
    public TextRowFactory(NativeProtocol protocol, ColumnDefinition colDefinition, Resultset.Concurrency resultSetConcurrency, boolean canReuseRowPacketForBufferRow) {
        this.columnDefinition = colDefinition;
        this.resultSetConcurrency = resultSetConcurrency;
        this.canReuseRowPacketForBufferRow = canReuseRowPacketForBufferRow;
        this.useBufferRowSizeThreshold = protocol.getPropertySet().getMemorySizeProperty(PropertyKey.largeRowSizeThreshold);
        this.exceptionInterceptor = protocol.getExceptionInterceptor();
        this.valueDecoder = new MysqlTextValueDecoder();
    }

    @Override
    public ResultsetRow createFromMessage(NativePacketPayload rowPacket) {
        boolean useBufferRow;
        boolean bl = useBufferRow = this.canReuseRowPacketForBufferRow || this.columnDefinition.hasLargeFields() || rowPacket.getPayloadLength() >= (Integer)this.useBufferRowSizeThreshold.getValue();
        if (this.resultSetConcurrency == Resultset.Concurrency.UPDATABLE || !useBufferRow) {
            byte[][] rowBytes = new byte[this.columnDefinition.getFields().length][];
            for (int i2 = 0; i2 < this.columnDefinition.getFields().length; ++i2) {
                rowBytes[i2] = rowPacket.readBytes(NativeConstants.StringSelfDataType.STRING_LENENC);
            }
            return new ByteArrayRow(rowBytes, this.exceptionInterceptor);
        }
        return new TextBufferRow(rowPacket, this.columnDefinition, this.exceptionInterceptor, this.valueDecoder);
    }

    @Override
    public boolean canReuseRowPacketForBufferRow() {
        return this.canReuseRowPacketForBufferRow;
    }
}

