/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj.result;

import gg.drak.thebase.lib.mysql.cj.Messages;
import gg.drak.thebase.lib.mysql.cj.conf.PropertyKey;
import gg.drak.thebase.lib.mysql.cj.conf.PropertySet;
import gg.drak.thebase.lib.mysql.cj.exceptions.DataConversionException;
import gg.drak.thebase.lib.mysql.cj.protocol.a.MysqlTextValueDecoder;
import gg.drak.thebase.lib.mysql.cj.result.DefaultValueFactory;
import gg.drak.thebase.lib.mysql.cj.result.Field;
import gg.drak.thebase.lib.mysql.cj.util.StringUtils;

public abstract class AbstractNumericValueFactory<T>
extends DefaultValueFactory<T> {
    public AbstractNumericValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public T createFromBytes(byte[] bytes, int offset, int length, Field f) {
        if (length == 0 && this.pset.getBooleanProperty(PropertyKey.emptyStringsConvertToZero).getValue().booleanValue()) {
            return this.createFromLong(0L);
        }
        String s2 = StringUtils.toString(bytes, offset, length, f.getEncoding());
        byte[] newBytes = s2.getBytes();
        if (s2.contains("e") || s2.contains("E") || s2.matches("-?\\d*\\.\\d*")) {
            return this.createFromDouble(MysqlTextValueDecoder.getDouble(newBytes, 0, newBytes.length));
        }
        if (s2.matches("-?\\d+")) {
            if (s2.charAt(0) == '-' || length <= 19 && newBytes[0] >= 48 && newBytes[0] <= 56) {
                return this.createFromLong(MysqlTextValueDecoder.getLong(newBytes, 0, newBytes.length));
            }
            return this.createFromBigInteger(MysqlTextValueDecoder.getBigInteger(newBytes, 0, newBytes.length));
        }
        throw new DataConversionException(Messages.getString("ResultSet.UnableToInterpretString", new Object[]{s2}));
    }

    @Override
    public T createFromYear(long l) {
        return this.createFromLong(l);
    }
}

