/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj.result;

import gg.drak.thebase.lib.mysql.cj.Constants;
import gg.drak.thebase.lib.mysql.cj.Messages;
import gg.drak.thebase.lib.mysql.cj.conf.PropertyKey;
import gg.drak.thebase.lib.mysql.cj.conf.PropertySet;
import gg.drak.thebase.lib.mysql.cj.exceptions.NumberOutOfRange;
import gg.drak.thebase.lib.mysql.cj.result.DefaultValueFactory;
import gg.drak.thebase.lib.mysql.cj.result.Field;
import gg.drak.thebase.lib.mysql.cj.util.DataTypeUtil;
import gg.drak.thebase.lib.mysql.cj.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ByteValueFactory
extends DefaultValueFactory<Byte> {
    public ByteValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public Byte createFromBigInteger(BigInteger i2) {
        if (this.jdbcCompliantTruncationForReads && (i2.compareTo(Constants.BIG_INTEGER_MIN_BYTE_VALUE) < 0 || i2.compareTo(Constants.BIG_INTEGER_MAX_BYTE_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{i2, this.getTargetTypeName()}));
        }
        return (byte)i2.intValue();
    }

    @Override
    public Byte createFromLong(long l) {
        if (this.jdbcCompliantTruncationForReads && (l < -128L || l > 127L)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{Long.valueOf(l).toString(), this.getTargetTypeName()}));
        }
        return (byte)l;
    }

    @Override
    public Byte createFromBigDecimal(BigDecimal d) {
        if (this.jdbcCompliantTruncationForReads && (d.compareTo(Constants.BIG_DECIMAL_MIN_BYTE_VALUE) < 0 || d.compareTo(Constants.BIG_DECIMAL_MAX_BYTE_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d, this.getTargetTypeName()}));
        }
        return (byte)d.longValue();
    }

    @Override
    public Byte createFromDouble(double d) {
        if (this.jdbcCompliantTruncationForReads && (d < -128.0 || d > 127.0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d, this.getTargetTypeName()}));
        }
        return (byte)d;
    }

    @Override
    public Byte createFromBit(byte[] bytes, int offset, int length) {
        long l = DataTypeUtil.bitToLong(bytes, offset, length);
        if (this.jdbcCompliantTruncationForReads && l >> 8 != 0L) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{Long.valueOf(l).toString(), this.getTargetTypeName()}));
        }
        return (byte)l;
    }

    @Override
    public Byte createFromYear(long l) {
        return this.createFromLong(l);
    }

    @Override
    public String getTargetTypeName() {
        return Byte.class.getName();
    }

    @Override
    public Byte createFromBytes(byte[] bytes, int offset, int length, Field f) {
        if (length == 0 && this.pset.getBooleanProperty(PropertyKey.emptyStringsConvertToZero).getValue().booleanValue()) {
            return (byte)0;
        }
        String s2 = StringUtils.toString(bytes, offset, length, f.getEncoding());
        byte[] newBytes = s2.getBytes();
        if (this.jdbcCompliantTruncationForReads && newBytes.length != 1) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{s2, this.getTargetTypeName()}));
        }
        return newBytes[0];
    }
}

