/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.classic.turbo;

import host.plas.bou.libs.logback.classic.Level;
import host.plas.bou.libs.logback.classic.Logger;
import host.plas.bou.libs.logback.classic.turbo.LRUMessageCache;
import host.plas.bou.libs.logback.classic.turbo.TurboFilter;
import host.plas.bou.libs.logback.core.spi.FilterReply;
import org.slf4j.Marker;

public class DuplicateMessageFilter
extends TurboFilter {
    public static final int DEFAULT_CACHE_SIZE = 100;
    public static final int DEFAULT_ALLOWED_REPETITIONS = 5;
    public int allowedRepetitions = 5;
    public int cacheSize = 100;
    private LRUMessageCache msgCache;

    @Override
    public void start() {
        this.msgCache = new LRUMessageCache(this.cacheSize);
        super.start();
    }

    @Override
    public void stop() {
        this.msgCache.clear();
        this.msgCache = null;
        super.stop();
    }

    @Override
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t2) {
        int count = this.msgCache.getMessageCountAndThenIncrement(format);
        if (count <= this.allowedRepetitions) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public int getAllowedRepetitions() {
        return this.allowedRepetitions;
    }

    public void setAllowedRepetitions(int allowedRepetitions) {
        this.allowedRepetitions = allowedRepetitions;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }
}

