/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MigrateArgs<K>
implements CompositeArgument {
    private boolean copy = false;
    private boolean replace = false;
    List<K> keys = new ArrayList<K>();
    private char[] password;
    private char[] username;

    public MigrateArgs<K> copy() {
        this.copy = true;
        return this;
    }

    public MigrateArgs<K> replace() {
        this.replace = true;
        return this;
    }

    public MigrateArgs<K> key(K key) {
        LettuceAssert.notNull(key, "Key must not be null");
        this.keys.add(key);
        return this;
    }

    @SafeVarargs
    public final MigrateArgs<K> keys(K ... keys) {
        LettuceAssert.notEmpty((Object[])keys, "Keys must not be empty");
        this.keys.addAll(Arrays.asList(keys));
        return this;
    }

    public MigrateArgs<K> keys(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        for (K key : keys) {
            this.keys.add(key);
        }
        return this;
    }

    public MigrateArgs<K> auth(CharSequence password) {
        LettuceAssert.notNull((Object)password, "Password must not be null");
        char[] chars = new char[password.length()];
        for (int i2 = 0; i2 < password.length(); ++i2) {
            chars[i2] = password.charAt(i2);
        }
        this.password = chars;
        return this;
    }

    public MigrateArgs<K> auth2(CharSequence username, CharSequence password) {
        LettuceAssert.notNull((Object)username, "Username must not be null");
        LettuceAssert.notNull((Object)password, "Password must not be null");
        char[] chars = new char[username.length()];
        for (int i2 = 0; i2 < username.length(); ++i2) {
            chars[i2] = username.charAt(i2);
        }
        this.username = chars;
        return this.auth(password);
    }

    public MigrateArgs<K> auth(char[] password) {
        LettuceAssert.notNull((Object)password, "Password must not be null");
        this.password = Arrays.copyOf(password, password.length);
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.copy) {
            args.add(CommandKeyword.COPY);
        }
        if (this.replace) {
            args.add(CommandKeyword.REPLACE);
        }
        if (this.password != null) {
            if (this.username != null) {
                args.add(CommandType.AUTH2).add(this.username);
            } else {
                args.add(CommandType.AUTH);
            }
            args.add(this.password);
        }
        if (this.keys.size() > 1) {
            args.add(CommandType.KEYS);
            args.addKeys((Iterable<K>)this.keys);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K> MigrateArgs<K> copy() {
            return new MigrateArgs().copy();
        }

        public static <K> MigrateArgs<K> replace() {
            return new MigrateArgs().replace();
        }

        public static <K> MigrateArgs<K> key(K key) {
            return new MigrateArgs<K>().key(key);
        }

        @SafeVarargs
        public static <K> MigrateArgs<K> keys(K ... keys) {
            return new MigrateArgs<K>().keys(keys);
        }

        public static <K> MigrateArgs<K> keys(Iterable<K> keys) {
            return new MigrateArgs<K>().keys(keys);
        }

        public static <K> MigrateArgs<K> auth(CharSequence password) {
            return new MigrateArgs().auth(password);
        }

        public static <K> MigrateArgs<K> auth2(CharSequence username, CharSequence password) {
            return new MigrateArgs().auth2(username, password);
        }

        public static <K> MigrateArgs<K> auth(char[] password) {
            return new MigrateArgs().auth(password);
        }
    }
}

