/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.models.stream;

public enum StreamEntryDeletionResult {
    UNKNOWN(-2),
    NOT_FOUND(-1),
    DELETED(1),
    NOT_DELETED_UNACKNOWLEDGED_OR_STILL_REFERENCED(2);

    private final int code;

    private StreamEntryDeletionResult(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static StreamEntryDeletionResult fromCode(int code) {
        switch (code) {
            case -1: {
                return NOT_FOUND;
            }
            case 1: {
                return DELETED;
            }
            case 2: {
                return NOT_DELETED_UNACKNOWLEDGED_OR_STILL_REFERENCED;
            }
        }
        return UNKNOWN;
    }

    public static StreamEntryDeletionResult fromLong(Long value) {
        if (value == null) {
            return null;
        }
        return StreamEntryDeletionResult.fromCode(value.intValue());
    }

    public String toString() {
        return this.name() + "(" + this.code + ")";
    }
}

