/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.search.AggregationReply;
import io.lettuce.core.search.SearchReplyParser;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class AggregateReplyParser<K, V>
implements ComplexDataParser<AggregationReply<K, V>> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(AggregateReplyParser.class);
    private final SearchReplyParser<K, V> searchReplyParser;
    private final boolean withCursor;

    public AggregateReplyParser(RedisCodec<K, V> codec, boolean withCursor) {
        this.searchReplyParser = new SearchReplyParser<K, V>(codec);
        this.withCursor = withCursor;
    }

    @Override
    public AggregationReply<K, V> parse(ComplexData data) {
        AggregationReply reply = new AggregationReply();
        if (data == null) {
            return reply;
        }
        try {
            if (!this.withCursor) {
                Object searchReply = this.searchReplyParser.parse(data);
                reply.addSearchReply(searchReply);
                return reply;
            }
            List<Object> aggregateResults = data.getDynamicList();
            if (aggregateResults == null || aggregateResults.isEmpty()) {
                return reply;
            }
            boolean replyRead = false;
            for (Object aggregateResult : aggregateResults) {
                if (aggregateResult instanceof Number) {
                    if (replyRead) {
                        reply.setCursorId(((Number)aggregateResult).longValue());
                        continue;
                    }
                    reply.setGroupCount(((Number)aggregateResult).longValue());
                    continue;
                }
                if (!(aggregateResult instanceof ComplexData)) continue;
                Object searchReply = this.searchReplyParser.parse((ComplexData)aggregateResult);
                reply.addSearchReply(searchReply);
                replyRead = true;
            }
            return reply;
        }
        catch (Exception e) {
            LOG.warn("Error while parsing the result returned from Redis", e);
            return reply;
        }
    }
}

