/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.search.SearchReply;
import io.lettuce.core.search.arguments.SearchArgs;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SearchReplyParser<K, V>
implements ComplexDataParser<SearchReply<K, V>> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(SearchReplyParser.class);
    private final RedisCodec<K, V> codec;
    private final boolean withScores;
    private final boolean withContent;
    private final boolean withIds;

    public SearchReplyParser(RedisCodec<K, V> codec, SearchArgs<K, V> args) {
        this.codec = codec;
        this.withScores = args != null && args.isWithScores();
        this.withContent = args == null || !args.isNoContent();
        this.withIds = true;
    }

    public SearchReplyParser(RedisCodec<K, V> codec) {
        this.codec = codec;
        this.withScores = false;
        this.withContent = true;
        this.withIds = false;
    }

    @Override
    public SearchReply<K, V> parse(ComplexData data) {
        try {
            if (data.isList()) {
                return new Resp2SearchResultsParser().parse(data);
            }
            return new Resp3SearchResultsParser().parse(data);
        }
        catch (Exception e) {
            LOG.warn("Unable to parse the result from Redis", e);
            return new SearchReply();
        }
    }

    class Resp3SearchResultsParser
    implements ComplexDataParser<SearchReply<K, V>> {
        private final ByteBuffer ATTRIBUTES_KEY = StringCodec.UTF8.encodeKey("attributes");
        private final ByteBuffer FORMAT_KEY = StringCodec.UTF8.encodeKey("format");
        private final ByteBuffer RESULTS_KEY = StringCodec.UTF8.encodeKey("results");
        private final ByteBuffer TOTAL_RESULTS_KEY = StringCodec.UTF8.encodeKey("total_results");
        private final ByteBuffer WARNING_KEY = StringCodec.UTF8.encodeKey("warning");
        private final ByteBuffer SCORE_KEY = StringCodec.UTF8.encodeKey("score");
        private final ByteBuffer ID_KEY = StringCodec.UTF8.encodeKey("id");
        private final ByteBuffer EXTRA_ATTRIBUTES_KEY = StringCodec.UTF8.encodeKey("extra_attributes");
        private final ByteBuffer VALUES_KEY = StringCodec.UTF8.encodeKey("values");
        private final ByteBuffer CURSOR_KEY = StringCodec.UTF8.encodeKey("cursor");

        Resp3SearchResultsParser() {
        }

        @Override
        public SearchReply<K, V> parse(ComplexData data) {
            SearchReply searchReply = new SearchReply();
            Map<Object, Object> resultsMap = data.getDynamicMap();
            if (resultsMap == null || resultsMap.isEmpty()) {
                return searchReply;
            }
            if (resultsMap.containsKey(this.RESULTS_KEY)) {
                ComplexData results = (ComplexData)resultsMap.get(this.RESULTS_KEY);
                results.getDynamicList().forEach(result -> {
                    SearchReply.SearchResult searchResult;
                    ComplexData resultData = (ComplexData)result;
                    Map<Object, Object> resultEntry = resultData.getDynamicMap();
                    if (resultEntry.containsKey(this.ID_KEY)) {
                        Object id = SearchReplyParser.this.codec.decodeKey((ByteBuffer)resultEntry.get(this.ID_KEY));
                        searchResult = new SearchReply.SearchResult(id);
                    } else {
                        searchResult = new SearchReply.SearchResult();
                    }
                    if (resultEntry.containsKey(this.SCORE_KEY)) {
                        if (resultEntry.get(this.SCORE_KEY) instanceof Double) {
                            searchResult.setScore((Double)resultEntry.get(this.SCORE_KEY));
                        } else {
                            ComplexData scores = (ComplexData)resultEntry.get(this.SCORE_KEY);
                            List<Object> scoresList = scores.getDynamicList();
                            searchResult.setScore((Double)scoresList.get(0));
                        }
                    }
                    if (resultEntry.containsKey(this.EXTRA_ATTRIBUTES_KEY)) {
                        ComplexData extraAttributes = (ComplexData)resultEntry.get(this.EXTRA_ATTRIBUTES_KEY);
                        extraAttributes.getDynamicMap().forEach((key, value) -> {
                            Object decodedKey = SearchReplyParser.this.codec.decodeKey((ByteBuffer)key);
                            Object decodedValue = SearchReplyParser.this.codec.decodeValue((ByteBuffer)value);
                            searchResult.addFields(decodedKey, decodedValue);
                        });
                    }
                    searchReply.addResult(searchResult);
                });
            }
            if (resultsMap.containsKey(this.TOTAL_RESULTS_KEY)) {
                searchReply.setCount((Long)resultsMap.get(this.TOTAL_RESULTS_KEY));
            }
            if (resultsMap.containsKey(this.CURSOR_KEY)) {
                searchReply.setCursorId((Long)resultsMap.get(this.CURSOR_KEY));
            }
            if (resultsMap.containsKey(this.WARNING_KEY)) {
                ComplexData warning = (ComplexData)resultsMap.get(this.WARNING_KEY);
                warning.getDynamicList().forEach(warningEntry -> searchReply.addWarning(SearchReplyParser.this.codec.decodeValue((ByteBuffer)warningEntry)));
            }
            return searchReply;
        }
    }

    class Resp2SearchResultsParser
    implements ComplexDataParser<SearchReply<K, V>> {
        Resp2SearchResultsParser() {
        }

        @Override
        public SearchReply<K, V> parse(ComplexData data) {
            SearchReply searchReply = new SearchReply();
            List<Object> resultsList = data.getDynamicList();
            if (resultsList == null || resultsList.isEmpty()) {
                return searchReply;
            }
            if (resultsList.size() == 2 && resultsList.get(1) instanceof Long) {
                List<Object> actualResults = ((ComplexData)resultsList.get(0)).getDynamicList();
                Long cursorId = (Long)resultsList.get(1);
                searchReply.setCursorId(cursorId);
                if (actualResults == null || actualResults.isEmpty()) {
                    return searchReply;
                }
                searchReply.setCount((Long)actualResults.get(0));
                if (actualResults.size() == 1) {
                    return searchReply;
                }
                this.parseResults(searchReply, actualResults);
            } else {
                searchReply.setCount((Long)resultsList.get(0));
                if (resultsList.size() == 1) {
                    return searchReply;
                }
                this.parseResults(searchReply, resultsList);
            }
            return searchReply;
        }

        private void parseResults(SearchReply<K, V> searchReply, List<Object> resultsList) {
            int i2 = 1;
            while (i2 < resultsList.size()) {
                Object id = SearchReplyParser.this.codec.decodeKey(StringCodec.UTF8.encodeKey("0"));
                if (SearchReplyParser.this.withIds) {
                    id = SearchReplyParser.this.codec.decodeKey((ByteBuffer)resultsList.get(i2));
                    ++i2;
                }
                SearchReply.SearchResult<Object, Object> searchResult = new SearchReply.SearchResult<Object, Object>(id);
                if (SearchReplyParser.this.withScores) {
                    searchResult.setScore(Double.parseDouble(StringCodec.UTF8.decodeKey((ByteBuffer)resultsList.get(i2))));
                    ++i2;
                }
                if (SearchReplyParser.this.withContent) {
                    ComplexData resultData = (ComplexData)resultsList.get(i2);
                    List<Object> resultEntries = resultData.getDynamicList();
                    Map<Object, Object> resultEntriesProcessed = IntStream.range(0, resultEntries.size() / 2).boxed().collect(Collectors.toMap(idx -> SearchReplyParser.this.codec.decodeKey((ByteBuffer)resultEntries.get(idx * 2)), idx -> SearchReplyParser.this.codec.decodeValue((ByteBuffer)resultEntries.get(idx * 2 + 1))));
                    searchResult.addFields(resultEntriesProcessed);
                    ++i2;
                }
                searchReply.addResult(searchResult);
            }
        }
    }
}

