/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import net.streamline.api.SLAPI;
import net.streamline.base.StreamlineVelocity;
import net.streamline.platform.savables.UserManager;
import org.jetbrains.annotations.Nullable;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.interfaces.IMessenger;
import singularity.modules.ModuleUtils;
import singularity.objects.CosmicTitle;
import singularity.text.HexPolicy;
import singularity.text.TextManager;
import singularity.utils.MessageUtils;

public class Messenger
implements IMessenger {
    private static Messenger instance;

    public Messenger() {
        instance = this;
    }

    public void sendMessage(@Nullable CommandSource to, String message) {
        if (to == null) {
            return;
        }
        if (!SLAPI.isReady()) {
            to.sendMessage(this.codedText(message));
        } else {
            to.sendMessage(this.codedText(this.replaceAllPlayerBungee(to, message)));
        }
    }

    public void sendMessage(@Nullable CommandSource to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        if (!SLAPI.isReady()) {
            to.sendMessage(this.codedText(message));
        } else {
            to.sendMessage(this.codedText(MessageUtils.replaceAllPlayerBungee(otherUUID, message)));
        }
    }

    public void sendMessage(@Nullable CommandSource to, CosmicSender other, String message) {
        if (to == null) {
            return;
        }
        if (!SLAPI.isReady()) {
            to.sendMessage(this.codedText(message));
        } else {
            to.sendMessage(this.codedText(MessageUtils.replaceAllPlayerBungee(other, message)));
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSource)StreamlineVelocity.getPlayer(to.getUuid()), message);
        } else {
            this.sendMessage((CommandSource)StreamlineVelocity.getInstance().getProxy().getConsoleCommandSource(), message);
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSource)StreamlineVelocity.getPlayer(to.getUuid()), otherUUID, message);
        } else {
            this.sendMessage((CommandSource)StreamlineVelocity.getInstance().getProxy().getConsoleCommandSource(), otherUUID, message);
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, CosmicSender other, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSource)StreamlineVelocity.getPlayer(to.getUuid()), other, message);
        } else {
            this.sendMessage((CommandSource)StreamlineVelocity.getInstance().getProxy().getConsoleCommandSource(), other, message);
        }
    }

    public void sendMessageRaw(CommandSource to, String message) {
        if (to == null) {
            return;
        }
        TextComponent component = !SLAPI.isReady() ? Component.text((String)message) : Component.text((String)this.replaceAllPlayerBungee(to, message));
        to.sendMessage((Component)component);
    }

    public void sendMessageRaw(CommandSource to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        TextComponent component = !SLAPI.isReady() ? Component.text((String)message) : Component.text((String)MessageUtils.replaceAllPlayerBungee(otherUUID, message));
        to.sendMessage((Component)component);
    }

    public void sendMessageRaw(CommandSource to, CosmicSender other, String message) {
        if (to == null) {
            return;
        }
        TextComponent component = !SLAPI.isReady() ? Component.text((String)message) : Component.text((String)MessageUtils.replaceAllPlayerBungee(other, message));
        to.sendMessage((Component)component);
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSource)StreamlineVelocity.getPlayer(to.getUuid()), message);
        } else {
            this.sendMessageRaw((CommandSource)StreamlineVelocity.getInstance().getProxy().getConsoleCommandSource(), message);
        }
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSource)StreamlineVelocity.getPlayer(to.getUuid()), otherUUID, message);
        } else {
            this.sendMessageRaw((CommandSource)StreamlineVelocity.getInstance().getProxy().getConsoleCommandSource(), otherUUID, message);
        }
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, CosmicSender other, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSource)StreamlineVelocity.getPlayer(to.getUuid()), other, message);
        } else {
            this.sendMessageRaw((CommandSource)StreamlineVelocity.getInstance().getProxy().getConsoleCommandSource(), other, message);
        }
    }

    @Override
    public void sendTitle(CosmicSender player, CosmicTitle title) {
        Player p = StreamlineVelocity.getPlayer(player.getUuid());
        if (p == null) {
            MessageUtils.logInfo("Could not send a title to a player because player is null!");
            return;
        }
        Title t2 = Title.title((Component)this.codedText(MessageUtils.replaceAllPlayerBungee(player, title.getMain())), (Component)this.codedText(MessageUtils.replaceAllPlayerBungee(player, title.getSub())), (Title.Times)Title.Times.times((Duration)Duration.of(title.getFadeIn() * 50L, ChronoUnit.MILLIS), (Duration)Duration.of(title.getStay() * 50L, ChronoUnit.MILLIS), (Duration)Duration.of(title.getFadeOut() * 50L, ChronoUnit.MILLIS)));
        p.showTitle(t2);
    }

    @Override
    public String codedString(String from) {
        return ModuleUtils.newLined(from);
    }

    @Override
    public String stripColor(String string) {
        return PlainTextComponentSerializer.plainText().serialize((Component)LegacyComponentSerializer.legacySection().deserialize(string)).replaceAll("([<][#][1-9a-f][1-9a-f][1-9a-f][1-9a-f][1-9a-f][1-9a-f][>])+", "").replaceAll("[&][1-9a-f]", "");
    }

    public String asString(Component textComponent) {
        return LegacyComponentSerializer.legacySection().serialize(textComponent);
    }

    public static Component legacyCode(String from) {
        return LegacyComponentSerializer.builder().extractUrls().character('&').hexColors().build().deserialize(from);
    }

    /*
     * WARNING - void declaration
     */
    public Component codedText(String from) {
        String raw = this.codedString(from);
        String legacy = MessageUtils.codedString(raw);
        ArrayList<Object> componentsList = new ArrayList<Object>();
        for (HexPolicy policy : TextManager.getHexPolicies()) {
            Iterator<String> iterator = TextManager.extractHexCodes(legacy, policy).iterator();
            while (iterator.hasNext()) {
                void var8_9;
                String string;
                String original = string = iterator.next();
                if (!string.startsWith("#")) {
                    String string2 = "#" + string;
                }
                legacy = legacy.replace(policy.getResult(original), LegacyComponentSerializer.legacyAmpersand().serialize((Component)Component.text((String)"", (TextColor)TextColor.fromCSSHexString((String)var8_9))));
            }
        }
        List<String> jsonStrings = TextManager.extractJsonStrings(legacy, "!!json:");
        int lastEnd = 0;
        for (String string : jsonStrings) {
            int index = legacy.indexOf("!!json:" + string);
            String before = legacy.substring(lastEnd, index);
            TextComponent beforeComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(before);
            componentsList.add(beforeComponent);
            try {
                Component jsonComponent = JSONComponentSerializer.json().deserialize((Object)string);
                componentsList.add(jsonComponent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            lastEnd = index + string.length() + 7;
        }
        if (lastEnd < legacy.length()) {
            TextComponent remainingComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(legacy.substring(lastEnd));
            componentsList.add(remainingComponent);
        }
        return Component.empty().children(componentsList);
    }

    public String replaceAllPlayerBungee(CommandSource sender, String of) {
        CosmicSender s2 = UserManager.getInstance().getOrCreateSender(sender).orElse(null);
        if (s2 == null) {
            return of;
        }
        return MessageUtils.replaceAllPlayerBungee(s2, of);
    }

    public static Messenger getInstance() {
        return instance;
    }
}

