/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.savables;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.streamline.api.permissions.LuckPermsHandler;
import net.streamline.base.StreamlineVelocity;
import net.streamline.platform.Messenger;
import singularity.interfaces.audiences.IPlayerInterface;
import singularity.interfaces.audiences.getters.PlayerGetter;
import singularity.interfaces.audiences.real.RealPlayer;

public class PlayerInterface
implements IPlayerInterface<Player> {
    @Override
    public PlayerGetter<Player> getPlayerGetter(UUID uuid) {
        return () -> StreamlineVelocity.getPlayer(uuid);
    }

    @Override
    public PlayerGetter<Player> getPlayerGetter(String playerName) {
        return () -> StreamlineVelocity.getPlayer(playerName);
    }

    @Override
    public RealPlayer<Player> getPlayer(PlayerGetter<Player> playerGetter) {
        return new RealPlayer<Player>(playerGetter){

            @Override
            public void chatAs(String command) {
                ((Player)this.getPlayer()).spoofChatInput(command);
            }

            @Override
            public void runCommand(String command) {
                StreamlineVelocity.getInstance().getProxy().getCommandManager().executeAsync((CommandSource)this.getPlayer(), command);
            }

            @Override
            public void sendMessage(String message) {
                ((Player)this.getPlayer()).sendMessage(Messenger.getInstance().codedText(message));
            }

            @Override
            public void sendMessageRaw(String message) {
                ((Player)this.getPlayer()).sendMessage((Component)Component.text((String)message));
            }

            @Override
            public boolean hasPermission(String permission) {
                return ((Player)this.getPlayer()).hasPermission(permission);
            }

            @Override
            public void addPermission(String permission) {
                LuckPermsHandler.addPermission(((Player)this.getPlayer()).getUniqueId().toString(), permission);
            }

            @Override
            public void removePermission(String permission) {
                LuckPermsHandler.removePermission(((Player)this.getPlayer()).getUniqueId().toString(), permission);
            }
        };
    }
}

