/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.ClassSelector;

@API(status=API.Status.STABLE, since="1.6")
public class NestedClassSelector
implements DiscoverySelector {
    private final ClassLoader classLoader;
    private final List<ClassSelector> enclosingClassSelectors;
    private final ClassSelector nestedClassSelector;

    NestedClassSelector(ClassLoader classLoader, List<String> enclosingClassNames, String nestedClassName) {
        this.classLoader = classLoader;
        this.enclosingClassSelectors = enclosingClassNames.stream().map(className -> new ClassSelector(classLoader, (String)className)).collect(CollectionUtils.toUnmodifiableList());
        this.nestedClassSelector = new ClassSelector(classLoader, nestedClassName);
    }

    NestedClassSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass) {
        this.classLoader = nestedClass.getClassLoader();
        this.enclosingClassSelectors = enclosingClasses.stream().map(ClassSelector::new).collect(Collectors.toList());
        this.nestedClassSelector = new ClassSelector(nestedClass);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<String> getEnclosingClassNames() {
        return this.enclosingClassSelectors.stream().map(ClassSelector::getClassName).collect(Collectors.toList());
    }

    public List<Class<?>> getEnclosingClasses() {
        return this.enclosingClassSelectors.stream().map(ClassSelector::getJavaClass).collect(Collectors.toList());
    }

    public String getNestedClassName() {
        return this.nestedClassSelector.getClassName();
    }

    public Class<?> getNestedClass() {
        return this.nestedClassSelector.getJavaClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedClassSelector that = (NestedClassSelector)o;
        return this.enclosingClassSelectors.equals(that.enclosingClassSelectors) && this.nestedClassSelector.equals(that.nestedClassSelector);
    }

    public int hashCode() {
        return Objects.hash(this.enclosingClassSelectors, this.nestedClassSelector);
    }

    public String toString() {
        return new ToStringBuilder(this).append("enclosingClassNames", this.getEnclosingClassNames()).append("nestedClassName", this.getNestedClassName()).append("classLoader", this.getClassLoader()).toString();
    }
}

