/*
 * Decompiled with CFR 0.152.
 */
package singularity.board.data;

import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.utils.MatcherUtils;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jetbrains.annotations.NotNull;
import singularity.board.data.BoardHeader;
import singularity.board.data.BoardSender;
import singularity.board.data.constructor.BoardConstructable;
import singularity.board.data.constructor.StringConstructable;

public class BoardData
implements Comparable<BoardData> {
    private BoardSender<?> sender;
    private BoardHeader header;
    private ConcurrentHashMap<String, BoardConstructable<?>> data;

    public String getIdentifier() {
        return this.sender.getOf().getClass().getSimpleName() + "->" + this.header.getHeader();
    }

    public BoardData(BoardSender<?> sender, BoardHeader header, ConcurrentHashMap<String, BoardConstructable<?>> data) {
        this.sender = sender;
        this.header = header;
        this.data = data;
    }

    public BoardData(BoardSender<?> sender, BoardHeader header) {
        this(sender, header, new ConcurrentHashMap());
    }

    public String buildAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append("!--sender=").append(this.sender.getIdentifier()).append(";");
        builder.append("!--header=").append(this.header.getHeader()).append(";");
        this.data.forEach((key, value) -> builder.append("!").append((String)key).append("=").append(value.construct()).append(";"));
        return builder.toString();
    }

    public BoardData(String sender, String header) {
        this(new BoardSender<String>(sender), new BoardHeader(header));
    }

    public static BoardData parseFrom(String from) {
        Matcher matcher = MatcherUtils.matcherBuilder("([!](.?*)[=](.?*)[;])", from);
        List<String[]> matches = MatcherUtils.getGroups(matcher, 3);
        BoardSender<String> sender = null;
        BoardHeader header = null;
        ConcurrentSkipListMap<String, StringConstructable> data = new ConcurrentSkipListMap<String, StringConstructable>();
        for (String[] match : matches) {
            if (match[1].equals("--sender")) {
                sender = new BoardSender<String>(match[2]);
                continue;
            }
            if (match[1].equals("--header")) {
                header = new BoardHeader(match[2]);
                continue;
            }
            data.put(match[1], new StringConstructable(match[2]));
        }
        return new BoardData(sender, header, new ConcurrentHashMap(data));
    }

    @Override
    public int compareTo(@NotNull BoardData o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public void setSender(BoardSender<?> sender) {
        this.sender = sender;
    }

    public void setHeader(BoardHeader header) {
        this.header = header;
    }

    public void setData(ConcurrentHashMap<String, BoardConstructable<?>> data) {
        this.data = data;
    }

    public BoardSender<?> getSender() {
        return this.sender;
    }

    public BoardHeader getHeader() {
        return this.header;
    }

    public ConcurrentHashMap<String, BoardConstructable<?>> getData() {
        return this.data;
    }
}

