/*
 * Decompiled with CFR 0.152.
 */
package singularity.command;

import singularity.Singularity;
import singularity.command.CommandExecution;
import singularity.data.players.CosmicPlayer;
import singularity.messages.proxied.ProxiedMessage;
import singularity.utils.MessageUtils;

public class CommandMessageBuilder {
    private static String subChannel = "main-command-message";

    public static ProxiedMessage build(CosmicPlayer carrier, String server, CommandExecution execution) {
        ProxiedMessage r = new ProxiedMessage(carrier, Singularity.isProxy());
        r.setSubChannel(CommandMessageBuilder.getSubChannel());
        r.write("server", server);
        r.write("command", execution.getCommand());
        r.write("as", execution.getSenderValue());
        return r;
    }

    public static void handle(ProxiedMessage in) {
        if (!in.getSubChannel().equals(CommandMessageBuilder.getSubChannel())) {
            return;
        }
        String server = in.getString("server");
        String command = in.getString("command");
        String as = in.getString("as");
        MessageUtils.logDebug("Handling command message: " + command);
        if (server == null || command == null || as == null) {
            MessageUtils.logWarning("Received a command message with null values: " + String.valueOf(in));
            return;
        }
        CommandExecution execution = new CommandExecution(as, command);
        execution.executeMayFail();
    }

    public static String getSubChannel() {
        return subChannel;
    }

    public static void setSubChannel(String subChannel) {
        CommandMessageBuilder.subChannel = subChannel;
    }
}

