/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.update;

import gg.drak.thebase.objects.Identifiable;
import java.util.Date;
import java.util.Optional;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.data.update.PullFunction;
import singularity.data.update.PutterFunction;
import singularity.data.update.UpdateFunction;
import singularity.data.update.UpdateManager;
import singularity.database.servers.UpdateInfo;

public class UpdateType<T>
implements Identifiable {
    private String identifier;
    private Class<T> type;
    private UpdateFunction parser;
    private PullFunction<T> puller;
    private PutterFunction<T> putter;
    private long millisBetweenUpdates;

    public UpdateType(String identifier, Class<T> type, UpdateFunction parser, PullFunction<T> puller, PutterFunction<T> putter, long millisBetweenUpdates) {
        this.setIdentifier(identifier);
        this.setType(type);
        this.setParser(parser);
        this.setPuller(puller);
        this.setPutter(putter);
        this.setMillisBetweenUpdates(millisBetweenUpdates);
    }

    public UpdateType(String identifier, Class<T> type, PullFunction<T> puller, PutterFunction<T> putter, long millisBetweenUpdates) {
        this(identifier, type, UpdateType.getDefaultParser(identifier), puller, putter, millisBetweenUpdates);
    }

    public void load() {
        UpdateManager.load(this);
    }

    public void unload() {
        UpdateManager.unload(this);
    }

    public boolean isLoaded() {
        return UpdateManager.isLoaded(this);
    }

    public void clear(String identifier) {
        Singularity.getMainDatabase().clearUpdateAsync(this, identifier);
    }

    public void update(String identifier) {
        Singularity.getMainDatabase().postUpdateAsync(this, identifier);
    }

    public boolean checkAndPut(String identifier) {
        return this.check(identifier).map(t2 -> {
            this.putter.accept(t2);
            this.clear(identifier);
            return true;
        }).orElse(false);
    }

    public Optional<T> check(String identifier) {
        if (this.isUpdateNeeded(identifier)) {
            return Optional.of(this.pull(identifier));
        }
        return Optional.empty();
    }

    public T pull(String identifier) {
        return (T)this.getPuller().apply(identifier);
    }

    public Optional<UpdateInfo> getLastUpdate(String identifier) {
        return (Optional)this.getParser().apply(identifier);
    }

    public boolean isUpdateNeeded(String identifier) {
        return this.getLastUpdate(identifier).map(info2 -> {
            if (info2.getServerUuid().equals(GivenConfigs.getServer().getUuid())) {
                return false;
            }
            return UpdateType.isUpdateNeeded(info2.getDate(), this.millisBetweenUpdates);
        }).orElse(true);
    }

    public UpdateFunction defaultParser(String identifier) {
        return s2 -> Singularity.getMainDatabase().checkUpdate(this, identifier).join();
    }

    public static long getAdjustedMillis(long millis) {
        return millis - 1L;
    }

    public static boolean isUpdateNeeded(long millis, long millisBetweenUpdates) {
        return UpdateType.getAdjustedMillis(millis) + millisBetweenUpdates < System.currentTimeMillis();
    }

    public static boolean isUpdateNeeded(Date date, long millisBetweenUpdates) {
        return UpdateType.isUpdateNeeded(date.getTime(), millisBetweenUpdates);
    }

    public static UpdateFunction getDefaultParser(String updateType) {
        return s2 -> UpdateManager.getLastUpdate(updateType, s2);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public Class<T> getType() {
        return this.type;
    }

    public UpdateFunction getParser() {
        return this.parser;
    }

    public PullFunction<T> getPuller() {
        return this.puller;
    }

    public PutterFunction<T> getPutter() {
        return this.putter;
    }

    public long getMillisBetweenUpdates() {
        return this.millisBetweenUpdates;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public void setParser(UpdateFunction parser) {
        this.parser = parser;
    }

    public void setPuller(PullFunction<T> puller) {
        this.puller = puller;
    }

    public void setPutter(PutterFunction<T> putter) {
        this.putter = putter;
    }

    public void setMillisBetweenUpdates(long millisBetweenUpdates) {
        this.millisBetweenUpdates = millisBetweenUpdates;
    }
}

