/*
 * Decompiled with CFR 0.152.
 */
package singularity.objects;

import com.google.common.io.BaseEncoding;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import lombok.NonNull;

public class CosmicFavicon {
    private static final TypeAdapter<CosmicFavicon> FAVICON_TYPE_ADAPTER = new TypeAdapter<CosmicFavicon>(){

        @Override
        public void write(JsonWriter out, CosmicFavicon value) throws IOException {
            TypeAdapters.STRING.write(out, value == null ? null : value.getEncoded());
        }

        @Override
        public CosmicFavicon read(JsonReader in) throws IOException {
            BufferedImage image;
            String enc = TypeAdapters.STRING.read(in);
            if (enc == null) {
                return null;
            }
            byte[] imageBytes = BaseEncoding.base64().decode(enc.substring("data:image/png;base64,".length()));
            try {
                image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            }
            catch (IOException e) {
                throw new IOException("Failed to decode favicon", e);
            }
            if (image.getWidth() != 64 || image.getHeight() != 64) {
                throw new IOException("Favicon must be exactly 64x64 pixels");
            }
            CosmicFavicon favicon = new CosmicFavicon(enc, image);
            if (favicon.getEncoded().length() > Short.MAX_VALUE) {
                throw new IOException("Favicon file too large for server to process");
            }
            return favicon;
        }
    };
    @NonNull
    private final String encoded;
    @NonNull
    private final BufferedImage image;

    public CosmicFavicon(@NonNull String encoded, @NonNull BufferedImage image) {
        if (encoded == null) {
            throw new NullPointerException("encoded is marked non-null but is null");
        }
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.encoded = encoded;
        this.image = image;
    }

    public static TypeAdapter<CosmicFavicon> getFaviconTypeAdapter() {
        return FAVICON_TYPE_ADAPTER;
    }

    public static CosmicFavicon create(BufferedImage image) {
        byte[] imageBytes;
        if (image.getWidth() != 64 || image.getHeight() != 64) {
            throw new IllegalArgumentException("Server icon must be exactly 64x64 pixels");
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", stream);
            imageBytes = stream.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        String encoded = "data:image/png;base64," + BaseEncoding.base64().encode(imageBytes);
        if (encoded.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Favicon file too large for server to process");
        }
        return new CosmicFavicon(encoded, image);
    }

    public static CosmicFavicon createFromURL(URL url) {
        try {
            return CosmicFavicon.create(ImageIO.read(url));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static CosmicFavicon createFromURL(String url) {
        try {
            return CosmicFavicon.createFromURL(URI.create(url).toURL());
        }
        catch (Throwable e) {
            return null;
        }
    }

    @NonNull
    public String getEncoded() {
        return this.encoded;
    }

    @NonNull
    public BufferedImage getImage() {
        return this.image;
    }
}

