/*
 * Decompiled with CFR 0.152.
 */
package singularity.text;

import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.objects.AtomicString;
import gg.drak.thebase.utils.MatcherUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HexReplacer
implements Comparable<HexReplacer> {
    public static final String HEX_REGEX = "([0-9a-fA-F]{6})";
    public static final String FULL_REGEX = "((%starter%)([0-9a-fA-F]{6})(%ender%))";
    private String starter;
    private String ender;
    private String setTo;

    public HexReplacer(String starter, String ender, String setTo) {
        this.starter = starter;
        this.ender = ender;
        this.setTo = setTo;
    }

    public HexReplacer() {
        this("{#", "}", "<#%hex%>");
    }

    public String getWith(String hex) {
        return this.getStarter() + hex + this.getEnder();
    }

    public String getRegex() {
        return FULL_REGEX.replace("%starter%", MatcherUtils.makeLiteral(this.getStarter())).replace("%ender%", MatcherUtils.makeLiteral(this.getEnder()));
    }

    public List<String[]> scan(String from) {
        Matcher matcher = MatcherUtils.matcherBuilder(this.getRegex(), from);
        return MatcherUtils.getGroups(matcher, 4);
    }

    public AtomicString replace(AtomicString text) {
        this.scan((String)text.get()).forEach(group -> {
            String hex = group[2];
            String with = this.getSetTo().replace("%hex%", hex);
            text.set(((String)text.get()).replace(group[1], with));
        });
        return text;
    }

    public String getIdentifiably() {
        return this.getStarter() + "123456" + this.getEnder();
    }

    @Override
    public int compareTo(@NotNull HexReplacer o) {
        return this.getIdentifiably().compareTo(o.getIdentifiably());
    }

    public void setStarter(String starter) {
        this.starter = starter;
    }

    public void setEnder(String ender) {
        this.ender = ender;
    }

    public void setSetTo(String setTo) {
        this.setTo = setTo;
    }

    public String getStarter() {
        return this.starter;
    }

    public String getEnder() {
        return this.ender;
    }

    public String getSetTo() {
        return this.setTo;
    }
}

