/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.client.render;

import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.render.tile.SawmillRenderer;
import com.hermitowo.advancedtfctech.client.render.RenderHelper;
import com.hermitowo.advancedtfctech.common.blockentities.FleshingMachineBlockEntity;
import com.hermitowo.advancedtfctech.config.ATTConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class FleshingMachineRenderer
extends IEBlockEntityRenderer<FleshingMachineBlockEntity> {
    private static final IVertexBufferHolder BLADES_BUFFER = IVertexBufferHolder.create(() -> SawmillRenderer.BLADE.getNullQuads());

    public void render(FleshingMachineBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (be.isDummy() || !be.getLevelNonnull().hasChunkAt(be.getBlockPos())) {
            return;
        }
        Direction facing = be.getFacing();
        VertexConsumer consumer = buffer.getBuffer(RenderType.solid());
        TextureAtlasSprite rodTexture = ClientUtils.getSprite((ResourceLocation)ResourceLocation.parse((String)"advancedtfctech:block/metal_device/fleshing_machine"));
        float bladeRotation = be.bladeAngle + (be.getIsActive() ? 36.0f * partialTicks : 0.0f);
        float hideRotation = be.rodAngle + (be.getIsActive() ? 9.0f * partialTicks : 0.0f);
        ItemStack blade = (ItemStack)be.getInventory().get(1);
        if (!blade.isEmpty()) {
            for (int i = 0; i < 20; ++i) {
                poseStack.pushPose();
                FleshingMachineRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                RenderHelper.translate(poseStack, 0.0625 + 0.0625 * (double)i, 0.6875, 0.4375);
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.scale(0.125f, 0.125f, 0.125f);
                poseStack.scale(1.1f, 1.1f, 4.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(bladeRotation));
                BLADES_BUFFER.render(RenderType.solid(), combinedLight, combinedOverlay, buffer, poseStack);
                poseStack.popPose();
            }
        }
        poseStack.pushPose();
        FleshingMachineRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
        RenderHelper.translate(poseStack, 0.25, 0.6875, 0.4375);
        poseStack.mulPose(Axis.XP.rotationDegrees(bladeRotation));
        RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, -1.0f, -1.0f, 21.0f, 1.0f, 1.0f, rodTexture, 0.0f, 21.0f, combinedLight);
        poseStack.popPose();
        ItemStack hide = (ItemStack)be.getInventory().get(0);
        if (!hide.isEmpty()) {
            HashMap<String, String> hideTextures = new HashMap<String, String>();
            hideTextures.put("tfc:small_soaked_hide", "advancedtfctech:block/metal_device/fleshing_machine/soaked");
            hideTextures.put("tfc:medium_soaked_hide", "advancedtfctech:block/metal_device/fleshing_machine/soaked");
            hideTextures.put("tfc:large_soaked_hide", "advancedtfctech:block/metal_device/fleshing_machine/soaked");
            hideTextures.put("tfc:small_scraped_hide", "advancedtfctech:block/metal_device/fleshing_machine/scraped");
            hideTextures.put("tfc:medium_scraped_hide", "advancedtfctech:block/metal_device/fleshing_machine/scraped");
            hideTextures.put("tfc:large_scraped_hide", "advancedtfctech:block/metal_device/fleshing_machine/scraped");
            Map<String, String> configTextures = ATTConfig.CLIENT.additionalFleshingMachineTextures.get().stream().filter(list -> !list.isEmpty()).collect(Collectors.toMap(list -> (String)list.get(0), list -> (String)list.get(1)));
            hideTextures.putAll(configTextures);
            ResourceLocation rl = ResourceLocation.tryParse((String)hideTextures.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(BuiltInRegistries.ITEM.getKey((Object)hide.getItem()).toString())).map(Map.Entry::getValue).findAny().orElse("neoforge:white"));
            rl = rl != null ? rl : ResourceLocation.parse((String)"neoforge:white");
            TextureAtlasSprite hideTexture = ClientUtils.getSprite((ResourceLocation)rl);
            poseStack.pushPose();
            FleshingMachineRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
            RenderHelper.translate(poseStack, 0.28125, 0.5, 0.625);
            poseStack.mulPose(Axis.XN.rotationDegrees(hideRotation));
            RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, -2.0f, -2.0f, 20.0f, 2.0f, 2.0f, hideTexture, combinedLight);
            poseStack.popPose();
        }
        poseStack.pushPose();
        FleshingMachineRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
        RenderHelper.translate(poseStack, 0.25, 0.5, 0.625);
        poseStack.mulPose(Axis.XN.rotationDegrees(hideRotation));
        RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, -1.0f, -1.0f, 21.0f, 1.0f, 1.0f, rodTexture, 0.0f, 21.0f, combinedLight);
        poseStack.popPose();
    }

    public static void reset() {
        BLADES_BUFFER.reset();
    }
}

