/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.client.render;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import com.hermitowo.advancedtfctech.AdvancedTFCTech;
import com.hermitowo.advancedtfctech.client.model.PowerLoomParts;
import com.hermitowo.advancedtfctech.client.render.RenderHelper;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.PowerLoomLogic;
import com.hermitowo.advancedtfctech.common.recipes.PowerLoomRecipe;
import com.hermitowo.advancedtfctech.config.ATTConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class PowerLoomRenderer
extends IEBlockEntityRenderer<MultiblockBlockEntityMaster<PowerLoomLogic.State>> {
    public static final Material material = new Material(InventoryMenu.BLOCK_ATLAS, AdvancedTFCTech.rl("block/multiblock/power_loom"));
    private final PowerLoomParts powerLoomModel;

    public PowerLoomRenderer(BlockEntityRendererProvider.Context context) {
        this.powerLoomModel = new PowerLoomParts(context.bakeLayer(PowerLoomParts.LAYER_LOCATION));
    }

    public void render(MultiblockBlockEntityMaster<PowerLoomLogic.State> be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IMultiblockContext ctx = be.getHelper().getContext();
        PowerLoomLogic.State state = (PowerLoomLogic.State)ctx.getState();
        MultiblockOrientation orientation = ctx.getLevel().getOrientation();
        Direction facing = orientation.front();
        boolean active = state.shouldRenderAsActive();
        boolean hasProcess = !state.getProcessQueue().isEmpty();
        float angle = state.rodAngle + (active ? 1.75f * partialTicks : 0.0f);
        buffer = RenderHelper.mirror(orientation, poseStack, buffer);
        VertexConsumer vertexConsumer = material.buffer(buffer, RenderType::entitySolid);
        poseStack.pushPose();
        PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
        RenderHelper.translate(poseStack, -0.6875, 0.625, -0.6875);
        poseStack.mulPose(Axis.ZN.rotationDegrees(angle));
        this.powerLoomModel.rod.render(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
        poseStack.pushPose();
        PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
        RenderHelper.translate(poseStack, 1.6875, 0.625, -0.6875);
        poseStack.mulPose(Axis.ZN.rotationDegrees(angle));
        this.powerLoomModel.rod.render(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
        float rack = state.rackDispl;
        rack = rack * rack * (3.0f - 2.0f * rack);
        poseStack.pushPose();
        PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        RenderHelper.translate(poseStack, -1.211 - (double)rack, 0.0, 1.9375);
        this.powerLoomModel.rack.render(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.translate(6.9375, 0.0, -0.25 + (double)state.rackSideDispl);
        this.powerLoomModel.rack_side.render(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
        poseStack.pushPose();
        PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        RenderHelper.translate(poseStack, -1.9375, 0.4375 - (double)state.rack2Displ, 1.9375);
        this.powerLoomModel.rack2.render(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
        poseStack.pushPose();
        PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        RenderHelper.translate(poseStack, -1.9375, -0.4375 + (double)state.rack2Displ, 1.9375);
        this.powerLoomModel.rack3.render(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
        poseStack.pushPose();
        PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        RenderHelper.translate(poseStack, -0.78125, -1.625, 2.0);
        float tilt = (float)state.holderRotation * 45.0f;
        poseStack.mulPose(Axis.ZP.rotationDegrees(state.pirnAngle + tilt));
        this.powerLoomModel.holder.render(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
        VertexConsumer consumer = buffer.getBuffer(RenderType.solid());
        ArrayList<ItemStack> pirnList = new ArrayList<ItemStack>(8);
        int amountPirns = 0;
        for (int i = 0; i < 8; ++i) {
            pirnList.add(state.inventory.getStackInSlot(i));
            amountPirns += state.inventory.getStackInSlot(i).getCount();
        }
        ItemStack pirn = pirnList.stream().filter(s -> !s.isEmpty()).findAny().orElse(ItemStack.EMPTY);
        amountPirns = hasProcess ? amountPirns - 1 : amountPirns;
        HashMap<String, String> pirnTextures = new HashMap<String, String>();
        pirnTextures.put("advancedtfctech:fiber_winded_pirn", "advancedtfctech:block/multiblock/power_loom/fiber_winded_pirn");
        pirnTextures.put("advancedtfctech:silk_winded_pirn", "advancedtfctech:block/multiblock/power_loom/wool_winded_pirn");
        pirnTextures.put("advancedtfctech:wool_winded_pirn", "advancedtfctech:block/multiblock/power_loom/wool_winded_pirn");
        pirnTextures.put("advancedtfctech:pineapple_winded_pirn", "advancedtfctech:block/multiblock/power_loom/pineapple_winded_pirn");
        Map<String, String> configTextures = ATTConfig.CLIENT.additionalPowerLoomPirnTextures.get().stream().filter(list -> !list.isEmpty()).collect(Collectors.toMap(list -> (String)list.get(0), list -> (String)list.get(1)));
        pirnTextures.putAll(configTextures);
        ResourceLocation rl = ResourceLocation.tryParse((String)pirnTextures.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(BuiltInRegistries.ITEM.getKey((Object)pirn.getItem()).toString())).map(Map.Entry::getValue).findAny().orElse("neoforge:white"));
        rl = rl != null ? rl : ResourceLocation.parse((String)"neoforge:white");
        TextureAtlasSprite pirnTexture = ClientUtils.getSprite((ResourceLocation)rl);
        for (int i = 0; i < amountPirns; ++i) {
            poseStack.pushPose();
            PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            RenderHelper.translate(poseStack, -0.78125, -1.625, 2.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(state.pirnAngle + 45.0f));
            poseStack.mulPose(Axis.ZN.rotationDegrees(45.0f * (float)i));
            if (hasProcess) {
                poseStack.mulPose(Axis.ZN.rotationDegrees(45.0f));
            }
            RenderHelper.renderTexturedPirn(consumer, poseStack, -1.0f, -5.0f, 0.0f, 1.0f, -3.0f, 9.0f, pirnTexture, combinedLight);
            poseStack.popPose();
        }
        if (hasProcess) {
            poseStack.pushPose();
            PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            RenderHelper.translate(poseStack, -0.78125, -1.625, 2.0);
            poseStack.translate(state.pirnDisplX - state.pirnDisplX2, state.pirnDisplY, -state.pirnDisplZ);
            poseStack.mulPose(Axis.ZP.rotationDegrees(state.pirnAngle + 45.0f));
            RenderHelper.renderTexturedPirn(consumer, poseStack, -1.0f, -5.0f, 0.0f, 1.0f, -3.0f, 9.0f, pirnTexture, combinedLight);
            poseStack.popPose();
        }
        RecipeHolder<PowerLoomRecipe> recipe = PowerLoomRecipe.findRecipeForRendering(ctx.getLevel().getRawLevel(), state.inventory.getStackInSlot(11));
        TextureAtlasSprite outputTexture = ClientUtils.getSprite((ResourceLocation)state.lastTexture);
        int amountOutput = state.inventory.getStackInSlot(12).getCount();
        if (amountOutput > 0) {
            int count = Math.floorDiv(amountOutput, 16);
            poseStack.pushPose();
            PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
            RenderHelper.translate(poseStack, -0.6875, 0.625, -0.5);
            poseStack.mulPose(Axis.ZN.rotationDegrees(angle));
            RenderHelper.renderTexturedBox(consumer, poseStack, -2.0f - (float)count / 2.0f, -2.0f - (float)count / 2.0f, 0.0f, 2.0f + (float)count / 2.0f, 2.0f + (float)count / 2.0f, 32.0f, outputTexture, 0.0f, 38.0f, combinedLight);
            poseStack.popPose();
        }
        if (recipe != null) {
            TextureAtlasSprite texture = ClientUtils.getSprite((ResourceLocation)((PowerLoomRecipe)recipe.value()).inProgressTexture);
            int amountWeave = 0;
            ArrayList<ItemStack> inputList = new ArrayList<ItemStack>(3);
            for (int i = 8; i < 11; ++i) {
                inputList.add(state.inventory.getStackInSlot(i));
            }
            for (ItemStack weave : inputList) {
                amountWeave += weave.getCount();
            }
            if (amountWeave > 0) {
                int count = Math.floorDiv(amountWeave, (int)(0.75 * (double)inputList.stream().filter(s -> !s.isEmpty()).findAny().orElse(ItemStack.EMPTY).getMaxStackSize()));
                poseStack.pushPose();
                PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                RenderHelper.translate(poseStack, 1.6875, 0.625, -0.5);
                poseStack.mulPose(Axis.ZN.rotationDegrees(angle));
                RenderHelper.renderTexturedBox(consumer, poseStack, -2.0f - (float)count / 2.0f, -2.0f - (float)count / 2.0f, 0.0f, 2.0f + (float)count / 2.0f, 2.0f + (float)count / 2.0f, 32.0f, texture, 0.0f, 38.0f, combinedLight);
                poseStack.popPose();
            }
            if (state.inventory.getStackInSlot(11).getCount() >= ((PowerLoomRecipe)recipe.value()).secondaryInput.getCount()) {
                poseStack.pushPose();
                PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                RenderHelper.translate(poseStack, -0.6875, 1.5, -0.5);
                RenderHelper.renderTexturedBox(consumer, poseStack, -2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 32.0f, texture, 0.0f, 38.0f, combinedLight);
                poseStack.translate(2.3125, 0.0, 0.0);
                RenderHelper.renderTexturedBox(consumer, poseStack, -2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 32.0f, texture, 0.0f, 38.0f, combinedLight);
                poseStack.popPose();
                poseStack.pushPose();
                PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                RenderHelper.translate(poseStack, -0.7, 0.7, -0.5);
                poseStack.mulPose(Axis.ZP.rotationDegrees(8.0f));
                RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, 0.0f, 0.0f, 1.0f, 11.0f, 32.0f, texture, 0.0f, 38 + state.weaveTextureDispl, combinedLight);
                poseStack.popPose();
                poseStack.pushPose();
                PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                RenderHelper.translate(poseStack, 1.575, 0.7, -0.5);
                poseStack.mulPose(Axis.ZN.rotationDegrees(8.0f));
                RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, 0.0f, 0.0f, 1.0f, 12.0f, 32.0f, texture, 0.0f, state.weaveTextureDispl, combinedLight);
                poseStack.popPose();
                for (int i = 0; i < 16; ++i) {
                    poseStack.pushPose();
                    PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                    RenderHelper.translate(poseStack, -0.71875, 1.65, -0.5 + (double)i * 0.125);
                    poseStack.mulPose(Axis.ZN.rotationDegrees(80.0f + state.longThreadAngle));
                    RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, 0.0f, 0.0f, 1.0f, 27.0f, 1.0f, texture, 0.0f, 0.0f, combinedLight);
                    poseStack.popPose();
                    poseStack.pushPose();
                    PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                    RenderHelper.translate(poseStack, -0.71875, 1.65, -0.4375 + (double)i * 0.125);
                    poseStack.mulPose(Axis.ZN.rotationDegrees(99.0f - state.longThreadAngle));
                    RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, 0.0f, 0.0f, 1.0f, 27.0f, 1.0f, texture, 0.0f, 0.0f, combinedLight);
                    poseStack.popPose();
                    poseStack.pushPose();
                    PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                    RenderHelper.translate(poseStack, 1.635, 1.585, -0.5 + (double)i * 0.125);
                    poseStack.mulPose(Axis.ZP.rotationDegrees(68.0f + state.shortThreadAngle));
                    RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, 0.0f, 0.0f, 1.0f, 13.0f, 1.0f, texture, 0.0f, 0.0f, combinedLight);
                    poseStack.popPose();
                    poseStack.pushPose();
                    PowerLoomRenderer.rotateForFacing((PoseStack)poseStack, (Direction)facing);
                    RenderHelper.translate(poseStack, 1.635, 1.585, -0.4375 + (double)i * 0.125);
                    poseStack.mulPose(Axis.ZP.rotationDegrees(110.0f - state.shortThreadAngle));
                    RenderHelper.renderTexturedBox(consumer, poseStack, 0.0f, 0.0f, 0.0f, 1.0f, 13.0f, 1.0f, texture, 0.0f, 0.0f, combinedLight);
                    poseStack.popPose();
                }
            }
        }
    }
}

