/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.client.render;

import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class RenderHelper {
    public static void renderTexturedBox(VertexConsumer wr, PoseStack stack, float x0, float y0, float z0, float x1, float y1, float z1, TextureAtlasSprite texture, float minU, float minV, int light) {
        float pixel = (texture.getU1() - texture.getU0()) / (float)texture.contents().width();
        float u0 = texture.getU0() + minU * pixel;
        float v0 = texture.getV0() + minV * pixel;
        RenderHelper.renderBox(wr, stack, x0 / 16.0f, y0 / 16.0f, z0 / 16.0f, x1 / 16.0f, y1 / 16.0f, z1 / 16.0f, u0, v0, pixel, light);
    }

    public static void renderTexturedBox(VertexConsumer wr, PoseStack stack, float x0, float y0, float z0, float x1, float y1, float z1, TextureAtlasSprite texture, int light) {
        RenderHelper.renderTexturedBox(wr, stack, x0, y0, z0, x1, y1, z1, texture, 0.0f, 0.0f, light);
    }

    public static void renderBox(VertexConsumer wr, PoseStack stack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float pixel, int light) {
        float normalX = 0.0f;
        float normalY = 0.0f;
        float normalZ = 1.0f;
        float dX = (x1 - x0) * 16.0f * pixel;
        float dY = (y1 - y0) * 16.0f * pixel;
        float dZ = (z1 - z0) * 16.0f * pixel;
        RenderHelper.putVertex(wr, stack, x0, y0, z1, u0, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z1, u0 + dX, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z1, u0 + dX, v0 + dY, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y1, z1, u0, v0 + dY, normalX, normalY, normalZ, light);
        normalZ = -1.0f;
        RenderHelper.putVertex(wr, stack, x0, y1, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z0, u0 + dX, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z0, u0 + dX, v0 + dY, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y0, z0, u0, v0 + dY, normalX, normalY, normalZ, light);
        normalZ = 0.0f;
        normalY = -1.0f;
        RenderHelper.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z0, u0 + dX, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z1, u0 + dX, v0 + dZ, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y0, z1, u0, v0 + dZ, normalX, normalY, normalZ, light);
        normalY = 1.0f;
        RenderHelper.putVertex(wr, stack, x0, y1, z1, u0, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z1, u0 + dX, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z0, u0 + dX, v0 + dZ, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y1, z0, u0, v0 + dZ, normalX, normalY, normalZ, light);
        normalY = 0.0f;
        normalX = -1.0f;
        RenderHelper.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y0, z1, u0 + dZ, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y1, z1, u0 + dZ, v0 + dY, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y1, z0, u0, v0 + dY, normalX, normalY, normalZ, light);
        normalX = 1.0f;
        RenderHelper.putVertex(wr, stack, x1, y1, z0, u0, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z1, u0 + dZ, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z1, u0 + dZ, v0 + dY, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z0, u0, v0 + dY, normalX, normalY, normalZ, light);
    }

    public static void renderTexturedPirn(VertexConsumer wr, PoseStack stack, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, TextureAtlasSprite texture, int light) {
        float pixel = (texture.getU1() - texture.getU0()) / (float)texture.contents().width();
        float u0 = texture.getU0();
        float v0 = texture.getV0();
        float x0 = minX / 16.0f;
        float y0 = minY / 16.0f;
        float z0 = minZ / 16.0f;
        float x1 = maxX / 16.0f;
        float y1 = maxY / 16.0f;
        float z1 = maxZ / 16.0f;
        float dX = (maxX - minX) * pixel;
        float dY = (maxY - minY) * pixel;
        float dZ = (maxZ - minZ) * pixel;
        float s = dX + Math.abs(dY - dZ);
        float normalX = 0.0f;
        float normalY = 0.0f;
        float normalZ = 1.0f;
        RenderHelper.putVertex(wr, stack, x0, y0, z1, u0 + s, v0 + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z1, u0 + dX + s, v0 + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z1, u0 + dX + s, v0 + dY + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y1, z1, u0 + s, v0 + dY + s, normalX, normalY, normalZ, light);
        normalZ = -1.0f;
        RenderHelper.putVertex(wr, stack, x0, y1, z0, u0 + s, v0 + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z0, u0 + dX + s, v0 + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z0, u0 + dX + s, v0 + dY + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y0, z0, u0 + s, v0 + dY + s, normalX, normalY, normalZ, light);
        normalZ = 0.0f;
        normalY = -1.0f;
        RenderHelper.putVertex(wr, stack, x0, y0, z0, u0 + s, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z0, u0 + dX + s, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z1, u0 + dX + s, v0 + dZ, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y0, z1, u0 + s, v0 + dZ, normalX, normalY, normalZ, light);
        normalY = 1.0f;
        RenderHelper.putVertex(wr, stack, x0, y1, z1, u0 + s, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z1, u0 + dX + s, v0, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z0, u0 + dX + s, v0 + dZ, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y1, z0, u0 + s, v0 + dZ, normalX, normalY, normalZ, light);
        normalY = 0.0f;
        normalX = -1.0f;
        RenderHelper.putVertex(wr, stack, x0, y0, z0, u0, v0 + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y0, z1, u0 + dZ, v0 + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y1, z1, u0 + dZ, v0 + dY + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x0, y1, z0, u0, v0 + dY + s, normalX, normalY, normalZ, light);
        normalX = 1.0f;
        RenderHelper.putVertex(wr, stack, x1, y1, z0, u0, v0 + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y1, z1, u0 + dZ, v0 + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z1, u0 + dZ, v0 + dY + s, normalX, normalY, normalZ, light);
        RenderHelper.putVertex(wr, stack, x1, y0, z0, u0, v0 + dY + s, normalX, normalY, normalZ, light);
    }

    public static MultiBufferSource mirror(MultiblockOrientation orientation, PoseStack mat, MultiBufferSource builderIn) {
        mat.translate(0.5, 0.5, 0.5);
        builderIn = BERenderUtils.mirror((MultiblockOrientation)orientation, (PoseStack)mat, (MultiBufferSource)builderIn);
        mat.translate(-0.5, -0.5, -0.5);
        return builderIn;
    }

    public static void translate(PoseStack stack, double x, double y, double z) {
        stack.translate(0.5, 0.5, 0.5);
        stack.translate(x, y, z);
        stack.translate(-0.5, -0.5, -0.5);
    }

    private static void putVertex(VertexConsumer b, PoseStack mat, float x, float y, float z, float u, float v, float nX, float nY, float nZ, int light) {
        b.addVertex(mat.last().pose(), x, y, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(mat.last(), nX, nY, nZ);
    }
}

