/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.client.screen;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import com.google.common.collect.ImmutableList;
import com.hermitowo.advancedtfctech.AdvancedTFCTech;
import com.hermitowo.advancedtfctech.common.container.BeamhouseContainer;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;

public class BeamhouseScreen
extends IEContainerScreen<BeamhouseContainer> {
    private static final ResourceLocation TEXTURE = AdvancedTFCTech.rl("textures/gui/beamhouse.png");
    private static final ResourceLocation TANK_OVERLAY = AdvancedTFCTech.rl("beamhouse/tank_overlay");
    private static final GuiButtonIE.ButtonTexture DISTRIBUTE = new GuiButtonIE.ButtonTexture(AdvancedTFCTech.rl("beamhouse/distribute"), AdvancedTFCTech.rl("beamhouse/distribute_hover"));
    private GuiButtonIE distributeButton;
    private static final DecimalFormat PROGRESS_PERCENTAGE = new DecimalFormat(" #00%");

    public BeamhouseScreen(BeamhouseContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, TEXTURE);
        this.imageWidth = 176;
        this.imageHeight = 184;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.leftPos + 157, this.topPos + 31, (IEnergyStorage)((BeamhouseContainer)this.menu).energy), (Object)new FluidInfoArea((IFluidTank)((BeamhouseContainer)this.menu).tank, new Rect2i(this.leftPos + 111, this.topPos + 30, 16, 47), 20, 51, TANK_OVERLAY));
    }

    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        if (this.distributeButton.isHoveredOrFocused() && ((BeamhouseContainer)this.menu).getCarried().isEmpty()) {
            addLine.accept((Component)Component.translatable((String)"advancedtfctech.gui.distribute"));
        }
    }

    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        for (BeamhouseContainer.ProcessSlot process : (List)((BeamhouseContainer)this.menu).processes.get()) {
            int slot = process.slot();
            int h = process.processStep();
            graphics.blit(this.background, this.leftPos + 33 + slot % 4 * 21, this.topPos + 13 + slot / 4 * 18 + (16 - h), 176, 16 - h, 2, h);
        }
    }

    @NotNull
    protected List<Component> getTooltipFromContainerItem(@NotNull ItemStack stack) {
        List ret = super.getTooltipFromContainerItem(stack);
        if (this.hoveredSlot != null) {
            ((List)((BeamhouseContainer)this.menu).processes.get()).forEach(processSlot -> {
                if (processSlot.slot() == this.hoveredSlot.index) {
                    MutableComponent progress = Component.literal((String)PROGRESS_PERCENTAGE.format(processSlot.processFloat())).withStyle(ChatFormatting.GRAY);
                    Object patt0$temp = ret.get(0);
                    if (patt0$temp instanceof MutableComponent) {
                        MutableComponent mutable = (MutableComponent)patt0$temp;
                        mutable.append((Component)progress);
                    } else {
                        ret.add(progress);
                    }
                }
            });
        }
        return ret;
    }

    public void init() {
        super.init();
        this.distributeButton = new GuiButtonIE(this.leftPos + 111, this.topPos + 9, 16, 16, (Component)Component.empty(), DISTRIBUTE, button -> {
            if (((BeamhouseContainer)this.menu).getCarried().isEmpty()) {
                this.autoSplitStacks();
            }
        }){

            public boolean isHoveredOrFocused() {
                return super.isHoveredOrFocused() && ((BeamhouseContainer)BeamhouseScreen.this.menu).getCarried().isEmpty();
            }
        };
        this.addRenderableWidget((GuiEventListener)this.distributeButton);
    }

    private void autoSplitStacks() {
        for (int j = 0; j < 12; ++j) {
            int emptySlot = -1;
            int largestSlot = -1;
            int largestCount = -1;
            for (int i = 0; i < 12; ++i) {
                if (((BeamhouseContainer)this.menu).getSlot(i).hasItem()) {
                    int count = ((BeamhouseContainer)this.menu).getSlot(i).getItem().getCount();
                    if (count <= 1 || count <= largestCount) continue;
                    largestSlot = i;
                    largestCount = count;
                    continue;
                }
                if (emptySlot >= 0) continue;
                emptySlot = i;
            }
            if (emptySlot < 0 || largestSlot < 0) break;
            this.slotClicked(((BeamhouseContainer)this.menu).getSlot(largestSlot), largestSlot, 1, ClickType.PICKUP);
            this.slotClicked(((BeamhouseContainer)this.menu).getSlot(emptySlot), emptySlot, 0, ClickType.PICKUP);
        }
    }
}

