/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.blockentities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.hermitowo.advancedtfctech.client.ATTSounds;
import com.hermitowo.advancedtfctech.common.blocks.FleshingMachineBlock;
import com.hermitowo.advancedtfctech.common.container.ATTContainerProvider;
import com.hermitowo.advancedtfctech.common.container.ATTContainerTypes;
import com.hermitowo.advancedtfctech.common.items.ATTItems;
import com.hermitowo.advancedtfctech.common.recipes.FleshingMachineRecipe;
import com.hermitowo.advancedtfctech.config.ATTConfig;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class FleshingMachineBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
ATTContainerProvider<FleshingMachineBlockEntity>,
IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IProcessBE,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.ISoundBE,
IModelOffsetProvider {
    public static final BlockPos MASTER_POS = BlockPos.ZERO;
    public static final BlockPos DUMMY_POS = new BlockPos(1, 0, 0);
    public static final int INPUT_SLOT = 0;
    public static final int BLADE_SLOT = 1;
    public float bladeAngle = 0.0f;
    public float rodAngle = 0.0f;
    public static final int NUM_SLOTS = 2;
    public static final int ENERGY_CAPACITY = 16000;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(16000);
    private final MultiblockCapability<IEnergyStorage> energyCap = MultiblockCapability.make((BlockEntity)this, be -> be.energyCap, FleshingMachineBlockEntity::master, (Object)this.energyStorage);
    private final IEBlockCapabilityCaches.IEBlockCapabilityCache<IItemHandler> output = IEBlockCapabilityCaches.create((BlockCapability)Capabilities.ItemHandler.BLOCK, () -> this.worldPosition.relative(this.getFacing(), -1), () -> ((FleshingMachineBlockEntity)this).getFacing(), () -> ((FleshingMachineBlockEntity)this).getLevel());
    public final Supplier<FleshingMachineRecipe> cachedRecipe = CachedRecipe.cached(FleshingMachineRecipe::findRecipe, () -> this.level, () -> (ItemStack)this.inventory.get(0));
    public int process = 0;
    public int processMax = 0;
    private final MultiblockCapability<IItemHandler> invHandler = MultiblockCapability.make((BlockEntity)this, be -> be.invHandler, FleshingMachineBlockEntity::master, (Object)new IEInventoryHandler(2, this, 0, new boolean[]{true, true}, new boolean[]{true, false}){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            assert (FleshingMachineBlockEntity.this.level != null);
            return FleshingMachineRecipe.isValidRecipeInput(FleshingMachineBlockEntity.this.level, (ItemStack)FleshingMachineBlockEntity.this.inventory.get(slot)) ? ItemStack.EMPTY : super.extractItem(slot, amount, simulate);
        }
    });
    public AABB renderBB;

    public FleshingMachineBlockEntity(BlockEntityType<FleshingMachineBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        Collections.fill(this.inventory, ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        EnergyHelper.deserializeFrom((EnergyStorage)this.energyStorage, (CompoundTag)nbt, (HolderLookup.Provider)provider);
        this.process = nbt.getInt("process");
        this.processMax = nbt.getInt("processMax");
        this.renderBB = null;
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        EnergyHelper.serializeTo((EnergyStorage)this.energyStorage, (CompoundTag)nbt, (HolderLookup.Provider)provider);
        nbt.putInt("process", this.process);
        nbt.putInt("processMax", this.processMax);
    }

    public void tickClient() {
        if (this.getIsActive()) {
            this.bladeAngle += 36.0f;
            this.bladeAngle %= 360.0f;
            this.rodAngle += 9.0f;
            this.rodAngle %= 360.0f;
            ImmersiveEngineering.proxy.handleTileSound((Holder)ATTSounds.FLESHING_MACHINE.holder(), (BlockEntity)this, !((ItemStack)this.inventory.get(1)).isEmpty(), 0.2f, 1.0f);
        }
    }

    public boolean shouldPlaySound(String sound) {
        return this.getIsActive();
    }

    public void tickServer() {
        IItemHandler outputHandler;
        ItemStack input = (ItemStack)this.inventory.get(0);
        ItemStack blade = (ItemStack)this.inventory.get(1);
        FleshingMachineRecipe recipe = this.cachedRecipe.get();
        boolean activeBeforeTick = this.getIsActive();
        if (this.process > 0) {
            if (input.isEmpty()) {
                this.process = 0;
                this.processMax = 0;
            } else if (recipe == null || recipe.time != this.processMax || blade.isEmpty()) {
                this.process = 0;
                this.processMax = 0;
                this.setActive(false);
            } else {
                consumption = recipe.energy / recipe.time;
                if (this.energyStorage.extractEnergy(consumption, true) == consumption) {
                    this.energyStorage.extractEnergy(consumption, false);
                    --this.process;
                    ItemUtils.damageStackableItem((ItemStack)blade, (Level)this.level, (int)1);
                }
            }
            this.setChanged();
        } else {
            if (activeBeforeTick) {
                if (recipe != null) {
                    ItemStack output = recipe.output.getStack(input);
                    this.inventory.set(0, (Object)output);
                }
                this.processMax = 0;
                this.setActive(false);
            }
            if (recipe != null && !blade.isEmpty() && this.energyStorage.extractEnergy(consumption = recipe.energy / recipe.time, true) == consumption) {
                this.processMax = this.process = recipe.time;
                this.setActive(true);
            }
        }
        boolean activeAfterTick = this.getIsActive();
        if (activeBeforeTick != activeAfterTick) {
            this.setChanged();
            BlockEntity be = Utils.getExistingTileEntity((Level)this.level, (BlockPos)new BlockPos(1, 0, 0));
            if (be instanceof FleshingMachineBlockEntity) {
                ((FleshingMachineBlockEntity)be).setActive(activeAfterTick);
            }
        }
        if (this.getIsActive() && recipe != null) {
            this.spawnParticles(recipe.input.getItems()[0], this.getFacing());
        }
        assert (this.level != null);
        if (this.level.getGameTime() % 8L == 0L && (outputHandler = (IItemHandler)this.output.getCapability()) != null && !FleshingMachineRecipe.isValidRecipeInput(this.level, input)) {
            ItemStack stack = input.copyWithCount(1);
            if ((stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).isEmpty()) {
                input.shrink(1);
                if (input.getCount() <= 0) {
                    this.inventory.set(0, (Object)ItemStack.EMPTY);
                    this.setChanged();
                    this.markContainingBlockForUpdate(null);
                }
            }
        }
    }

    private void spawnParticles(ItemStack stack, Direction facing) {
        if (facing == Direction.EAST) {
            this.spawnParticles(stack, facing, 0.45, 0.708);
            this.spawnParticles(stack, facing, 0.45, 1.167);
        } else if (facing == Direction.SOUTH) {
            this.spawnParticles(stack, facing, 0.292, 0.45);
            this.spawnParticles(stack, facing, -0.167, 0.45);
        } else if (facing == Direction.WEST) {
            this.spawnParticles(stack, facing, 0.55, 0.292);
            this.spawnParticles(stack, facing, 0.55, -0.167);
        } else {
            this.spawnParticles(stack, facing, 0.708, 0.55);
            this.spawnParticles(stack, facing, 1.167, 0.55);
        }
    }

    private void spawnParticles(ItemStack stack, Direction facing, double x, double z) {
        boolean facingX = facing.getAxis().equals((Object)Direction.Axis.X);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), (double)this.getBlockPos().getX() + x, (double)this.getBlockPos().getY() + 0.65, (double)this.getBlockPos().getZ() + z, 1, facingX ? 0.0 : 0.2, 0.0, facingX ? 0.2 : 0.0, 0.03125);
        }
    }

    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        FleshingMachineBlockEntity master = this.master();
        if (master != null && (side.equals((Object)this.getFacing().getOpposite()) || side == Direction.UP)) {
            assert (this.level != null);
            ItemStack input = (ItemStack)master.inventory.get(0);
            ItemStack blade = (ItemStack)master.inventory.get(1);
            FleshingMachineRecipe recipe = FleshingMachineRecipe.findRecipe(this.level, heldItem);
            if (recipe != null && input.isEmpty()) {
                ItemStack stack = heldItem.copy();
                stack.setCount(1);
                master.inventory.set(0, (Object)stack);
                heldItem.shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
            if (blade.isEmpty() && heldItem.is(((Item)ATTItems.FLESHING_BLADES.get()).asItem())) {
                ItemStack stack = heldItem.copy();
                stack.setCount(1);
                master.inventory.set(1, (Object)stack);
                heldItem.shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown()) {
                if (!input.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)input.copy());
                    int size = input.getCount();
                    input.shrink(size);
                    return ItemInteractionResult.SUCCESS;
                }
                if (!blade.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)blade.copy());
                    blade.shrink(1);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void doGraphicalUpdates() {
        this.setChanged();
        this.markContainingBlockForUpdate(null);
    }

    public int[] getCurrentProcessesStep() {
        FleshingMachineBlockEntity master = this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    public int[] getCurrentProcessesMax() {
        FleshingMachineBlockEntity master = this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<FleshingMachineBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, facing) -> {
            if (facing == null || facing == be.getFacing().getClockWise()) {
                return (IEnergyStorage)be.energyCap.get();
            }
            return null;
        });
        registrar.register(Capabilities.ItemHandler.BLOCK, (be, facing) -> (IItemHandler)be.invHandler.get());
    }

    @Nullable
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        assert (this.level != null);
        if (slot == 0) {
            return FleshingMachineRecipe.isValidRecipeInput(this.level, stack);
        }
        return stack.is((Item)ATTItems.FLESHING_BLADES.get());
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean canUseGui(Player player) {
        return ATTConfig.SERVER.enableFleshingMachineDebug.get();
    }

    public FleshingMachineBlockEntity getGuiMaster() {
        if (!this.isDummy()) {
            return this;
        }
        Direction dummyDir = this.getFacing().getCounterClockWise();
        assert (this.level != null);
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.relative(dummyDir));
        if (be instanceof FleshingMachineBlockEntity) {
            return (FleshingMachineBlockEntity)be;
        }
        return null;
    }

    @Override
    public ATTContainerTypes.ATTArgContainer<? super FleshingMachineBlockEntity, ?> getContainerTypeATT() {
        return ATTContainerTypes.FLESHING_MACHINE;
    }

    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    public boolean isDummy() {
        return (Boolean)this.getState().getValue((Property)IEProperties.MULTIBLOCKSLAVE);
    }

    @Nullable
    public FleshingMachineBlockEntity master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterBE != null) {
            return (FleshingMachineBlockEntity)this.tempMasterBE;
        }
        Direction dummyDir = this.isDummy() ? this.getFacing().getCounterClockWise() : this.getFacing().getClockWise();
        BlockPos masterPos = this.getBlockPos().relative(dummyDir);
        BlockEntity be = Utils.getExistingTileEntity((Level)this.level, (BlockPos)masterPos);
        return be instanceof FleshingMachineBlockEntity ? (FleshingMachineBlockEntity)be : null;
    }

    public void placeDummies(BlockPlaceContext context, BlockState state) {
        assert (this.level != null);
        FleshingMachineBlock.placeDummies(this.getBlockState(), this.level, this.worldPosition, context);
    }

    public void breakDummies(BlockPos pos, BlockState state) {
        Direction dummyDir;
        this.tempMasterBE = this.master();
        Direction direction = dummyDir = this.isDummy() ? this.getFacing().getCounterClockWise() : this.getFacing().getClockWise();
        assert (this.level != null);
        this.level.removeBlock(pos.relative(dummyDir), false);
    }

    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        return this.isDummy() ? DUMMY_POS : MASTER_POS;
    }
}

