/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.collect.ImmutableList;
import com.hermitowo.advancedtfctech.common.blockentities.ATTBlockEntities;
import com.hermitowo.advancedtfctech.common.blockentities.FleshingMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FleshingMachineBlock
extends IEEntityBlock<FleshingMachineBlockEntity> {
    public static final Property<Direction> FACING = IEProperties.FACING_HORIZONTAL;
    public static final Property<Boolean> DUMMY = IEProperties.MULTIBLOCKSLAVE;
    private static final CachedShapesWithTransform<Boolean, Direction> SHAPES = CachedShapesWithTransform.createDirectional(dummy -> {
        if (dummy.booleanValue()) {
            return ImmutableList.of((Object)FleshingMachineBlock.pixel(15.0, 5.0, 5.0, 16.0, 11.0, 11.0), (Object)FleshingMachineBlock.pixel(9.0, 0.0, 0.0, 15.0, 12.0, 16.0), (Object)FleshingMachineBlock.pixel(9.0, 12.0, 0.0, 15.0, 16.0, 12.0), (Object)FleshingMachineBlock.pixel(0.0, 14.0, 0.0, 9.0, 16.0, 10.0), (Object)FleshingMachineBlock.pixel(0.0, 5.0, 0.0, 9.0, 6.0, 16.0), (Object)FleshingMachineBlock.pixel(0.0, 1.0, 11.0, 9.0, 3.0, 14.0), (Object)FleshingMachineBlock.pixel(0.0, 6.0, 0.0, 9.0, 14.0, 2.0));
        }
        return ImmutableList.of((Object)FleshingMachineBlock.pixel(0.0, 0.0, 0.0, 4.0, 12.0, 16.0), (Object)FleshingMachineBlock.pixel(0.0, 12.0, 0.0, 4.0, 16.0, 12.0), (Object)FleshingMachineBlock.pixel(4.0, 14.0, 0.0, 16.0, 16.0, 10.0), (Object)FleshingMachineBlock.pixel(4.0, 5.0, 0.0, 16.0, 6.0, 16.0), (Object)FleshingMachineBlock.pixel(4.0, 1.0, 11.0, 16.0, 3.0, 14.0), (Object)FleshingMachineBlock.pixel(4.0, 6.0, 0.0, 16.0, 14.0, 2.0));
    });

    public FleshingMachineBlock() {
        super(ATTBlockEntities.FLESHING_MACHINE, (BlockBehaviour.Properties)IEBlocks.METAL_PROPERTIES_NO_OCCLUSION.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DUMMY, FACING, IEProperties.ACTIVE});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction newFacing = rot.rotate((Direction)state.getValue(FACING));
        return (BlockState)state.setValue(FACING, (Comparable)newFacing);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction oldFacing = (Direction)state.getValue(FACING);
        Direction newFacing = mirror.mirror(oldFacing);
        boolean oldDummy = (Boolean)state.getValue(DUMMY);
        boolean newDummy = !oldDummy;
        return (BlockState)((BlockState)state.setValue(FACING, (Comparable)newFacing)).setValue(DUMMY, (Comparable)Boolean.valueOf(newDummy));
    }

    public boolean canIEBlockBePlaced(BlockState newState, BlockPlaceContext context) {
        BlockPos start = context.getClickedPos();
        Direction facing = PlacementLimitation.HORIZONTAL.getDirectionForPlacement(context);
        Direction dummyDir = FleshingMachineBlock.getDummyOffset(context.getLevel(), context.getClickedPos(), facing, context);
        return FleshingMachineBlock.areAllReplaceable((BlockPos)start, (BlockPos)start.relative(dummyDir), (BlockPlaceContext)context);
    }

    public BlockState updateShape(BlockState state, Direction updateSide, BlockState updatedState, LevelAccessor world, BlockPos currentPos, BlockPos updatedPos) {
        Direction facing = (Direction)state.getValue(FACING);
        boolean dummy = (Boolean)state.getValue(DUMMY);
        BlockPos otherHalf = currentPos.relative(facing.getClockWise(), dummy ? -1 : 1);
        BlockState otherState = world.getBlockState(otherHalf);
        if (otherState.getBlock() == this && otherState.getValue(FACING) == facing && (Boolean)otherState.getValue(DUMMY) == !dummy) {
            return state;
        }
        for (Direction candidate : FACING.getPossibleValues()) {
            BlockPos otherHalf2;
            BlockState otherState2;
            if (candidate == facing || (otherState2 = world.getBlockState(otherHalf2 = currentPos.relative(candidate.getClockWise(), dummy ? -1 : 1))).getBlock() != this || otherState2.getValue(FACING) != candidate || (Boolean)otherState2.getValue(DUMMY) != !dummy) continue;
            return (BlockState)state.setValue(FACING, (Comparable)candidate);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static Direction getDummyOffset(Level world, BlockPos pos, Direction facing, BlockPlaceContext context) {
        Direction dummyDir = facing.getAxis() == Direction.Axis.X ? (context.getClickLocation().z < 0.5 ? Direction.NORTH : Direction.SOUTH) : (context.getClickLocation().x < 0.5 ? Direction.WEST : Direction.EAST);
        BlockPos dummyPos = pos.relative(dummyDir);
        if (!world.getBlockState(dummyPos).canBeReplaced(BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)dummyPos, (Direction)dummyDir))) {
            dummyDir = dummyDir.getOpposite();
        }
        return dummyDir;
    }

    public static void placeDummies(BlockState state, Level world, BlockPos pos, BlockPlaceContext context) {
        boolean mirror;
        Direction facing = (Direction)state.getValue(FACING);
        Direction dummyDir = FleshingMachineBlock.getDummyOffset(world, pos, facing, context);
        BlockPos dummyPos = pos.relative(dummyDir);
        boolean bl = mirror = dummyDir != facing.getClockWise();
        if (mirror) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(DUMMY, (Comparable)Boolean.valueOf(true)));
        }
        world.setBlockAndUpdate(dummyPos, (BlockState)state.setValue(DUMMY, (Comparable)Boolean.valueOf(!mirror)));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Object)((Boolean)state.getValue(DUMMY)), (Object)((Direction)state.getValue(FACING)));
    }

    private static AABB pixel(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AABB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }
}

