/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.container;

import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.hermitowo.advancedtfctech.common.container.ATTContainerMenu;
import com.hermitowo.advancedtfctech.common.container.sync.ATTGenericContainerData;
import com.hermitowo.advancedtfctech.common.container.sync.ATTGenericDataSerializers;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.BeamhouseLogic;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTMultiblockProcess;
import com.hermitowo.advancedtfctech.common.recipes.BeamhouseRecipe;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class BeamhouseContainer
extends ATTContainerMenu {
    public final IMutableEnergyStorage energy;
    public final FluidTank tank;
    public final GetterAndSetter<List<ProcessSlot>> processes;

    public static BeamhouseContainer makeServer(MenuType<?> type, int id, Inventory playerInventory, IEContainerMenu.MultiblockMenuContext<BeamhouseLogic.State> ctx) {
        BeamhouseLogic.State state = (BeamhouseLogic.State)ctx.mbContext().getState();
        return new BeamhouseContainer(BeamhouseContainer.multiblockCtx(type, (int)id, ctx), playerInventory, (IItemHandler)state.getInventory(), (IMutableEnergyStorage)state.getEnergy(), state.getTank(), (GetterAndSetter<List<ProcessSlot>>)GetterAndSetter.getterOnly(() -> state.getProcessQueue().stream().filter(p -> p instanceof ATTMultiblockProcess.ProcessWithItemStackProvider).map(p -> ProcessSlot.fromCtx((ATTMultiblockProcess.ProcessWithItemStackProvider)((Object)((Object)p)), ctx.mbContext().getLevel().getRawLevel())).toList()));
    }

    public static BeamhouseContainer makeClient(MenuType<?> type, int id, Inventory playerInventory) {
        return new BeamhouseContainer(BeamhouseContainer.clientCtx(type, (int)id), playerInventory, (IItemHandler)new ItemStackHandler(17), (IMutableEnergyStorage)new MutableEnergyStorage(32000), new FluidTank(24000), (GetterAndSetter<List<ProcessSlot>>)GetterAndSetter.standalone(List.of()));
    }

    public BeamhouseContainer(IEContainerMenu.MenuContext ctx, final Inventory playerInventory, IItemHandler inv, IMutableEnergyStorage energy, FluidTank tank, GetterAndSetter<List<ProcessSlot>> processes) {
        super(ctx);
        int i;
        this.energy = energy;
        this.tank = tank;
        this.processes = processes;
        for (i = 0; i < 12; ++i) {
            this.addSlot((Slot)new SlotItemHandler(this, inv, i, 16 + 21 * (i % 4), 13 + 18 * (i / 4)){

                public boolean mayPlace(@Nonnull ItemStack stack) {
                    return BeamhouseRecipe.isValidRecipeInput(playerInventory.player.level(), stack);
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            this.addSlot((Slot)new IESlot.NewOutput(inv, i + 12, 46 + 18 * i, 72));
        }
        this.addSlot((Slot)new IESlot.NewFluidContainer(inv, 15, 133, 28, IESlot.NewFluidContainer.Filter.ANY));
        this.addSlot((Slot)new IESlot.NewOutput(inv, 16, 133, 64));
        this.ownSlotCount = 17;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 103 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 161));
        }
        this.addGenericData(GenericContainerData.energy((IMutableEnergyStorage)energy));
        this.addGenericData(GenericContainerData.fluid((FluidTank)tank));
        this.addGenericData(new ATTGenericContainerData<List<ProcessSlot>>(ATTGenericDataSerializers.BEAMHOUSE_PROCESS_SLOTS, processes));
    }

    public record ProcessSlot(int slot, int processStep, float processFloat) {
        public static final StreamCodec<ByteBuf, ProcessSlot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ProcessSlot::slot, (StreamCodec)ByteBufCodecs.INT, ProcessSlot::processStep, (StreamCodec)ByteBufCodecs.FLOAT, ProcessSlot::processFloat, ProcessSlot::new);

        public static ProcessSlot fromCtx(ATTMultiblockProcess.ProcessWithItemStackProvider<BeamhouseRecipe> process, Level level) {
            float mod = (float)process.processTick / (float)process.getMaxTicks(level);
            int slot = process.getInputSlots()[0];
            int h = (int)Math.max(1.0f, mod * 16.0f);
            return new ProcessSlot(slot, h, mod);
        }

        public static ProcessSlot from(FriendlyByteBuf buffer) {
            return new ProcessSlot(buffer.readByte(), buffer.readByte(), buffer.readFloat());
        }

        public static void writeTo(FriendlyByteBuf out, ProcessSlot slot) {
            out.writeByte(slot.slot).writeByte(slot.processStep).writeFloat(slot.processFloat);
        }
    }
}

