/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.container;

import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.hermitowo.advancedtfctech.common.container.ATTContainerMenu;
import com.hermitowo.advancedtfctech.common.container.sync.ATTGenericContainerData;
import com.hermitowo.advancedtfctech.common.container.sync.ATTGenericDataSerializers;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.GristMillLogic;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTMultiblockProcess;
import com.hermitowo.advancedtfctech.common.recipes.GristMillRecipe;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class GristMillContainer
extends ATTContainerMenu {
    public final IMutableEnergyStorage energy;
    public final GetterAndSetter<List<ProcessSlot>> processes;

    public static GristMillContainer makeServer(MenuType<?> type, int id, Inventory playerInventory, IEContainerMenu.MultiblockMenuContext<GristMillLogic.State> ctx) {
        GristMillLogic.State state = (GristMillLogic.State)ctx.mbContext().getState();
        return new GristMillContainer(GristMillContainer.multiblockCtx(type, (int)id, ctx), playerInventory, (IItemHandler)state.getInventory(), (IMutableEnergyStorage)state.getEnergy(), (GetterAndSetter<List<ProcessSlot>>)GetterAndSetter.getterOnly(() -> state.getProcessQueue().stream().filter(p -> p instanceof ATTMultiblockProcess.ProcessWithItemStackProvider).map(p -> ProcessSlot.fromCtx((ATTMultiblockProcess.ProcessWithItemStackProvider)((Object)((Object)p)), ctx.mbContext().getLevel().getRawLevel())).toList()));
    }

    public static GristMillContainer makeClient(MenuType<?> type, int id, Inventory playerInventory) {
        return new GristMillContainer(GristMillContainer.clientCtx(type, (int)id), playerInventory, (IItemHandler)new ItemStackHandler(12), (IMutableEnergyStorage)new MutableEnergyStorage(32000), (GetterAndSetter<List<ProcessSlot>>)GetterAndSetter.standalone(List.of()));
    }

    public GristMillContainer(IEContainerMenu.MenuContext ctx, final Inventory playerInventory, IItemHandler inv, IMutableEnergyStorage energy, GetterAndSetter<List<ProcessSlot>> processes) {
        super(ctx);
        int i;
        this.energy = energy;
        this.processes = processes;
        for (i = 0; i < 6; ++i) {
            this.addSlot((Slot)new SlotItemHandler(this, inv, i, 62 + 18 * (i % 3), 16 + 18 * (i / 3)){

                public boolean mayPlace(@Nonnull ItemStack stack) {
                    return GristMillRecipe.findRecipe(playerInventory.player.level(), stack) != null;
                }
            });
        }
        for (i = 0; i < 6; ++i) {
            this.addSlot((Slot)new IESlot.NewOutput(inv, i + 6, 62 + 18 * (i % 3), 74 + 18 * (i / 3)));
        }
        this.ownSlotCount = 12;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 126 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 184));
        }
        this.addGenericData(GenericContainerData.energy((IMutableEnergyStorage)energy));
        this.addGenericData(new ATTGenericContainerData<List<ProcessSlot>>(ATTGenericDataSerializers.GRIST_MILL_PROCESS_SLOTS, processes));
    }

    public record ProcessSlot(int processStep) {
        public static final StreamCodec<ByteBuf, ProcessSlot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ProcessSlot::processStep, ProcessSlot::new);

        public static ProcessSlot fromCtx(ATTMultiblockProcess.ProcessWithItemStackProvider<GristMillRecipe> process, Level level) {
            float mod = (float)process.processTick / (float)process.getMaxTicks(level);
            int h = (int)Math.max(1.0f, mod * 16.0f);
            return new ProcessSlot(h);
        }

        public static ProcessSlot from(FriendlyByteBuf buffer) {
            return new ProcessSlot(buffer.readByte());
        }

        public static void writeTo(FriendlyByteBuf out, ProcessSlot slot) {
            out.writeByte(slot.processStep);
        }
    }
}

