/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.container.sync;

import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.hermitowo.advancedtfctech.common.container.sync.ATTGenericDataSerializers;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ATTGenericContainerData<T> {
    private final ATTGenericDataSerializers.DataSerializer<T> serializer;
    private final Supplier<T> get;
    private final Consumer<T> set;
    private T current;

    public ATTGenericContainerData(ATTGenericDataSerializers.DataSerializer<T> serializer, Supplier<T> get, Consumer<T> set) {
        this.serializer = serializer;
        this.get = get;
        this.set = set;
    }

    public ATTGenericContainerData(ATTGenericDataSerializers.DataSerializer<T> serializer, GetterAndSetter<T> io) {
        this.serializer = serializer;
        this.get = io.getter();
        this.set = io.setter();
    }

    public boolean needsUpdate() {
        T newValue = this.get.get();
        if (newValue == null && this.current == null) {
            return false;
        }
        if (this.current != null && newValue != null && this.serializer.equals().test(this.current, newValue)) {
            return false;
        }
        this.current = this.serializer.copy().apply(newValue);
        return true;
    }

    public void processSync(Object receivedData) {
        this.current = receivedData;
        this.set.accept(this.serializer.copy().apply(this.current));
    }

    public ATTGenericDataSerializers.DataPair<T> dataPair() {
        return new ATTGenericDataSerializers.DataPair<T>(this.serializer, this.current);
    }
}

