/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.container.sync;

import com.hermitowo.advancedtfctech.common.container.BeamhouseContainer;
import com.hermitowo.advancedtfctech.common.container.GristMillContainer;
import com.hermitowo.advancedtfctech.common.container.PowerLoomContainer;
import com.hermitowo.advancedtfctech.common.container.ThresherContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class ATTGenericDataSerializers {
    private static final List<DataSerializer<?>> SERIALIZERS = new ArrayList();
    public static final DataSerializer<List<ThresherContainer.ProcessSlot>> THRESHER_PROCESS_SLOTS = ATTGenericDataSerializers.register(ThresherContainer.ProcessSlot.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DataSerializer<List<GristMillContainer.ProcessSlot>> GRIST_MILL_PROCESS_SLOTS = ATTGenericDataSerializers.register(GristMillContainer.ProcessSlot.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DataSerializer<List<PowerLoomContainer.ProcessSlot>> POWER_LOOM_PROCESS_SLOTS = ATTGenericDataSerializers.register(PowerLoomContainer.ProcessSlot.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DataSerializer<List<BeamhouseContainer.ProcessSlot>> BEAMHOUSE_PROCESS_SLOTS = ATTGenericDataSerializers.register(BeamhouseContainer.ProcessSlot.STREAM_CODEC.apply(ByteBufCodecs.list()));

    private static <T> DataSerializer<T> register(StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        return ATTGenericDataSerializers.register(codec, t -> t, Objects::equals);
    }

    private static <T> DataSerializer<T> register(StreamCodec<? super RegistryFriendlyByteBuf, T> codec, UnaryOperator<T> copy, BiPredicate<T, T> equals) {
        DataSerializer<T> serializer = new DataSerializer<T>(codec, copy, equals, SERIALIZERS.size());
        SERIALIZERS.add(serializer);
        return serializer;
    }

    public record DataSerializer<T>(StreamCodec<? super RegistryFriendlyByteBuf, T> codec, UnaryOperator<T> copy, BiPredicate<T, T> equals, int id) {
        private DataPair<T> read(RegistryFriendlyByteBuf from) {
            return new DataPair<Object>(this, this.codec.decode((Object)from));
        }
    }

    public record DataPair<T>(DataSerializer<T> serializer, T data) {
        public static final StreamCodec<RegistryFriendlyByteBuf, DataPair<?>> CODEC = new StreamCodec<RegistryFriendlyByteBuf, DataPair<?>>(){

            @NotNull
            public DataPair<?> decode(RegistryFriendlyByteBuf buffer) {
                DataSerializer<?> serializer = SERIALIZERS.get(buffer.readVarInt());
                return serializer.read(buffer);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buffer, DataPair<?> data) {
                data.write(buffer);
            }
        };

        private void write(RegistryFriendlyByteBuf to) {
            to.writeVarInt(this.serializer.id());
            this.serializer.codec.encode((Object)to, this.data);
        }
    }
}

