/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.multiblocks.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ATTMultiblockLogicHelper {
    public static <S extends IMultiblockState & ProcessContext<?>> void sort(S state, int firstSlot, int slotCount) {
        IItemHandlerModifiable inventory = ((ProcessContext<?>)state).getInventory();
        for (int i = firstSlot; i < firstSlot + slotCount; ++i) {
            for (int j = i + 1; j < firstSlot + slotCount; ++j) {
                ItemStack holder2;
                ItemStack holder1 = inventory.getStackInSlot(i).copy();
                if (!ItemStack.isSameItemSameComponents((ItemStack)holder1, (ItemStack)(holder2 = inventory.getStackInSlot(j).copy()))) continue;
                int size1 = holder1.getCount();
                int size2 = holder2.getCount();
                int sizeMax = holder1.getMaxStackSize();
                if (size1 == sizeMax || size2 == sizeMax) continue;
                if (size1 + size2 > sizeMax) {
                    if (size1 >= size2) {
                        int amount = sizeMax - size2;
                        inventory.getStackInSlot(i).shrink(amount);
                        inventory.getStackInSlot(j).grow(amount);
                        continue;
                    }
                    int amount = sizeMax - size1;
                    inventory.getStackInSlot(i).grow(amount);
                    inventory.getStackInSlot(j).shrink(amount);
                    continue;
                }
                ItemStack stack = holder1.copyWithCount(size1 + size2);
                inventory.setStackInSlot(i, stack);
                inventory.setStackInSlot(j, ItemStack.EMPTY);
            }
        }
    }

    public static <S extends IMultiblockState & ProcessContext<?>> void handleItemOutput(S state, Supplier<@Nullable IItemHandler> output, int[] outputSlots) {
        IItemHandler outputHandler = output.get();
        if (outputHandler != null) {
            for (int i : outputSlots) {
                ItemStack nextStack = ((ProcessContext<?>)state).getInventory().getStackInSlot(i);
                if (nextStack.isEmpty()) continue;
                ItemStack stack = nextStack.copyWithCount(1);
                if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).isEmpty()) continue;
                nextStack.shrink(1);
            }
        }
    }
}

