/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.multiblocks.logic;

import com.hermitowo.advancedtfctech.common.recipes.BeamhouseRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class BeamhouseInputHandler
implements IItemHandler {
    private final IItemHandlerModifiable wrapped;
    private final Runnable onChanged;
    private final Supplier<@Nullable Level> getLevel;

    public BeamhouseInputHandler(IItemHandlerModifiable wrapped, Runnable onChanged, Supplier<@Nullable Level> getLevel) {
        this.wrapped = wrapped;
        this.onChanged = onChanged;
        this.getLevel = getLevel;
    }

    public int getSlots() {
        return 17;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        boolean b = this.isItemValid(slot, stack);
        if (!b) {
            return stack;
        }
        stack = stack.copy();
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>(12);
        for (int i = 0; i < 12; ++i) {
            ItemStack here = this.wrapped.getStackInSlot(i);
            if (here.isEmpty()) {
                if (!simulate) {
                    this.wrapped.setStackInSlot(i, stack);
                }
                this.onChanged.run();
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)here) || here.getCount() >= here.getMaxStackSize()) continue;
            possibleSlots.add(i);
        }
        possibleSlots.sort(Comparator.comparingInt(a -> this.wrapped.getStackInSlot(a.intValue()).getCount()));
        Iterator iterator = possibleSlots.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ItemStack here = this.wrapped.getStackInSlot(i);
            int fillCount = Math.min(here.getMaxStackSize() - here.getCount(), stack.getCount());
            if (!simulate) {
                here.grow(fillCount);
            }
            stack.shrink(fillCount);
            if (!stack.isEmpty()) continue;
            this.onChanged.run();
            return ItemStack.EMPTY;
        }
        this.onChanged.run();
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return BeamhouseRecipe.isValidRecipeInput(this.getLevel.get(), stack);
    }
}

