/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.hermitowo.advancedtfctech.client.ATTSounds;
import com.hermitowo.advancedtfctech.common.container.ATTContainerTypes;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.ATTMultiblockLogicHelper;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.BeamhouseInputHandler;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTMultiblockProcess;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTProcessContext;
import com.hermitowo.advancedtfctech.common.multiblocks.shapes.BeamhouseShapes;
import com.hermitowo.advancedtfctech.common.recipes.BeamhouseRecipe;
import com.hermitowo.advancedtfctech.util.FluidHelper;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class BeamhouseLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_POS = new BlockPos(3, 1, 2);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(0, 1, 3, RelativeBlockFace.UP);
    public static final int FIRST_IN_SLOT = 0;
    public static final int IN_SLOT_COUNT = 12;
    public static final int FIRST_OUT_SLOT = 12;
    public static final int OUT_SLOT_COUNT = 3;
    public static final int CONTAINER_IN_SLOT = 15;
    public static final int CONTAINER_OUT_SLOT = 16;
    private static final MultiblockFace IN_POS = new MultiblockFace(4, 0, 1, RelativeBlockFace.RIGHT);
    private static final MultiblockFace OUT_POS = new MultiblockFace(3, 0, -1, RelativeBlockFace.FRONT);
    private static final CapabilityPosition FLUID_CAP = new CapabilityPosition(2, 0, 3, RelativeBlockFace.BACK);
    private static final CapabilityPosition IN_CAP = CapabilityPosition.opposing((MultiblockFace)IN_POS);
    private static final CapabilityPosition OUT_CAP = CapabilityPosition.opposing((MultiblockFace)OUT_POS);
    private static final int[] OUTPUT_SLOTS = new int[]{12, 13, 14};
    public static final int NUM_SLOTS = 17;
    public static final int ENERGY_CAPACITY = 32000;
    public static final int TANK_CAPACITY = 24000;

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        boolean active = state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        if (active != state.active) {
            state.active = active;
            context.requestMasterBESync();
        }
        this.enqueueProcesses(state, context.getLevel().getRawLevel());
        if (context.getLevel().shouldTickModulo(8)) {
            ATTMultiblockLogicHelper.handleItemOutput(state, state.output, OUTPUT_SLOTS);
        }
        if (FluidHelper.drainFluidContainer((IItemHandlerModifiable)state.inventory, state.tank, 15, 16)) {
            context.requestMasterBESync();
        }
    }

    private void enqueueProcesses(State state, Level level) {
        Object inputAmounts;
        Int2IntOpenHashMap usedInvSlots = new Int2IntOpenHashMap();
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!(process instanceof ATTMultiblockProcess.ProcessWithItemStackProvider)) continue;
            ATTMultiblockProcess.ProcessWithItemStackProvider beamhouseProcess = (ATTMultiblockProcess.ProcessWithItemStackProvider)process;
            int[] inputSlots = beamhouseProcess.getInputSlots();
            inputAmounts = beamhouseProcess.getInputAmounts();
            if (inputAmounts == null) continue;
            for (int i = 0; i < inputSlots.length; ++i) {
                if (inputAmounts[i] <= 0) continue;
                usedInvSlots.addTo(inputSlots[i], inputAmounts[i]);
            }
        }
        for (int slot = 0; slot < 12; ++slot) {
            ATTMultiblockProcess process;
            RecipeHolder<BeamhouseRecipe> recipe;
            ItemStack stack;
            if (state.tank.isEmpty() || usedInvSlots.containsKey(slot) || (stack = state.inventory.getStackInSlot(slot)).isEmpty() || (recipe = BeamhouseRecipe.findRecipe(level, stack, state.tank.getFluid())) == null) continue;
            int fluidAmount = 0;
            inputAmounts = state.getProcessQueue().iterator();
            while (inputAmounts.hasNext()) {
                MultiblockProcess processInQueue = (MultiblockProcess)inputAmounts.next();
                BeamhouseRecipe recipeInQueue = (BeamhouseRecipe)processInQueue.getRecipe(level);
                if (recipeInQueue == null) continue;
                fluidAmount += recipeInQueue.fluidInput.amount();
            }
            if (state.tank.getFluidAmount() < (fluidAmount += ((BeamhouseRecipe)recipe.value()).fluidInput.amount()) || !state.processor.addProcessToQueue(process = new ATTMultiblockProcess.ProcessWithItemStackProvider<BeamhouseRecipe>(recipe, slot).setInputTanks(0), level, false)) continue;
            process.setInputAmounts(((BeamhouseRecipe)recipe.value()).input.getCount());
        }
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (state.active) {
            state.barrelAngle = (state.barrelAngle + 18.0f) % 360.0f;
        }
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.active, (BooleanSupplier)context.isValid(), (Vec3)soundPos, (Holder)ATTSounds.BEAMHOUSE.holder(), (float)0.5f);
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> registrar) {
        registrar.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_POS, state -> state.energy);
        registrar.registerAtOrNull(Capabilities.FluidHandler.BLOCK, FLUID_CAP, state -> state.fluidInputHandler);
        registrar.register(Capabilities.ItemHandler.BLOCK, (state, position) -> {
            if (OUT_CAP.equals((Object)position)) {
                return state.outputHandler;
            }
            if (IN_CAP.equals((Object)position)) {
                return state.insertionHandler;
            }
            return null;
        });
        registrar.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandlerModifiable)state.inventory, drop);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return BeamhouseShapes.SHAPE_GETTER;
    }

    public ItemInteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (isClient) {
            return ItemInteractionResult.SUCCESS;
        }
        State state = (State)ctx.getState();
        if (FLUID_CAP.posInMultiblock().equals((Object)posInMultiblock)) {
            if (FluidHelper.interactWithFluidHandler(player, hand, (IFluidHandler)state.tank, state.getProcessQueue().isEmpty())) {
                ctx.markMasterDirty();
                ctx.requestMasterBESync();
            } else {
                player.openMenu(ATTContainerTypes.BEAMHOUSE.provide(ctx, posInMultiblock));
            }
        } else {
            player.openMenu(ATTContainerTypes.BEAMHOUSE.provide(ctx, posInMultiblock));
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static class State
    implements IMultiblockState,
    ATTProcessContext<BeamhouseRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        private final MultiblockProcessor<BeamhouseRecipe, ATTProcessContext<BeamhouseRecipe>> processor;
        public final SlotwiseItemHandler inventory;
        public final FluidTank tank = new FluidTank(24000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final Supplier<@Nullable IItemHandler> output;
        private final IItemHandler insertionHandler;
        private final IItemHandler outputHandler;
        private final IFluidHandler fluidInputHandler;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;
        private boolean active;
        public float barrelAngle = 0.0f;
        private BooleanSupplier isPlayingSound = () -> false;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            @Nullable Supplier getLevel = ctx.levelSupplier();
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.input(arg_0 -> State.lambda$new$1((Supplier)getLevel, arg_0)), 12), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 3), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.FLUID_INPUT, 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 1)), (Runnable)markDirty);
            this.processor = new MultiblockProcessor(12, 0.0f, 12, markDirty, (arg_0, arg_1) -> BeamhouseRecipe.RECIPES.getById(arg_0, arg_1));
            this.output = ctx.getCapabilityAt(Capabilities.ItemHandler.BLOCK, OUT_POS);
            this.insertionHandler = new BeamhouseInputHandler((IItemHandlerModifiable)this.inventory, markDirty, getLevel);
            this.outputHandler = new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(12, 15));
            this.fluidInputHandler = ArrayFluidHandler.fillOnly((IFluidTank)this.tank, (Runnable)markDirty);
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.insertionHandler, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.outputHandler, MachineInterfaceHandler.BASIC_ITEM_OUT), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.fluidInputHandler, MachineInterfaceHandler.BASIC_FLUID_IN), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("energy", this.energy.serializeNBT(provider));
            nbt.put("processor", this.processor.toNBT(provider));
            nbt.put("inventory", this.inventory.serializeNBT(provider));
            nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
        }

        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.energy.deserializeNBT(provider, nbt.get("energy"));
            this.processor.fromNBT(nbt.get("processor"), (getRecipe, data, p) -> new ATTMultiblockProcess.ProcessWithItemStackProvider(getRecipe, data), provider);
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.tank.readFromNBT(provider, nbt.getCompound("tank"));
        }

        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("active", this.active);
        }

        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.active = nbt.getBoolean("active");
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public IItemHandlerModifiable getInventory() {
            return this.inventory.getRawHandler();
        }

        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tank};
        }

        @Override
        public int[] getOutputSlots() {
            return OUTPUT_SLOTS;
        }

        public FluidTank getTank() {
            return this.tank;
        }

        public boolean shouldRenderAsActive() {
            return this.active;
        }

        public List<MultiblockProcess<BeamhouseRecipe, ATTProcessContext<BeamhouseRecipe>>> getProcessQueue() {
            return this.processor.getQueue();
        }

        private static /* synthetic */ boolean lambda$new$1(Supplier getLevel, ItemStack stack) {
            return BeamhouseRecipe.isValidRecipeInput((Level)getLevel.get(), stack);
        }
    }
}

