/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import com.hermitowo.advancedtfctech.common.container.ATTContainerTypes;
import com.hermitowo.advancedtfctech.common.items.ATTItems;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.ATTMultiblockLogicHelper;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTMultiblockProcess;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTProcessContext;
import com.hermitowo.advancedtfctech.common.multiblocks.shapes.PowerLoomSelectionShapes;
import com.hermitowo.advancedtfctech.common.multiblocks.shapes.PowerLoomShapes;
import com.hermitowo.advancedtfctech.common.recipes.PowerLoomRecipe;
import com.hermitowo.advancedtfctech.config.ATTConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PowerLoomLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_POS = new BlockPos(1, 0, 4);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(1, 1, 0, RelativeBlockFace.UP);
    public static final int FIRST_PIRN_IN_SLOT = 0;
    public static final int PIRN_IN_SLOT_COUNT = 8;
    public static final int FIRST_WEAVE_IN_SLOT = 8;
    public static final int WEAVE_IN_SLOT_COUNT = 3;
    public static final int SECONDARY_WEAVE_IN_SLOT = 11;
    public static final int OUT_SLOT = 12;
    private static final Set<BlockPos> WEAVE_IN_POS = Set.of(new BlockPos(2, 0, 1), new BlockPos(2, 0, 2), new BlockPos(2, 0, 3));
    private static final Set<MultiblockFace> OUT_POS = Set.of(new MultiblockFace(-1, 0, 1, RelativeBlockFace.LEFT), new MultiblockFace(-1, 0, 2, RelativeBlockFace.LEFT), new MultiblockFace(-1, 0, 3, RelativeBlockFace.LEFT));
    private static final MultiblockFace MAIN_OUT_POS = new MultiblockFace(-1, 0, 2, RelativeBlockFace.LEFT);
    private static final MultiblockFace SECONDARY_OUT_POS = new MultiblockFace(3, 0, 4, RelativeBlockFace.LEFT);
    private static final BlockPos PIRN_IN_POS = new BlockPos(1, 1, 4);
    private static final BlockPos SECONDARY_WEAVE_IO_POS = new BlockPos(1, 1, 2);
    private static final Set<CapabilityPosition> OUT_CAP = OUT_POS.stream().map(CapabilityPosition::opposing).collect(Collectors.toSet());
    public static final int NUM_SLOTS = 13;
    public static final int ENERGY_CAPACITY = 32000;

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        boolean active = state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        if (active != state.active) {
            state.active = active;
            context.requestMasterBESync();
        }
        this.enqueueProcesses(state, context.getLevel().getRawLevel());
        if (context.getLevel().shouldTickModulo(8)) {
            ATTMultiblockLogicHelper.sort(state, 8, 3);
            ATTMultiblockLogicHelper.handleItemOutput(state, state.output, state.getOutputSlots());
            context.requestMasterBESync();
        }
    }

    private void enqueueProcesses(State state, Level level) {
        if (state.energy.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return;
        }
        ItemStack secondaryWeave = state.inventory.getStackInSlot(11);
        if (secondaryWeave.isEmpty()) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            ItemStack pirn = state.inventory.getStackInSlot(i);
            if (pirn.isEmpty()) continue;
            for (int j = 8; j < 11; ++j) {
                RecipeHolder<PowerLoomRecipe> recipe;
                ItemStack weave = state.inventory.getStackInSlot(j);
                if (weave.isEmpty() || (recipe = PowerLoomRecipe.findRecipe(level, pirn, weave)) == null || !((PowerLoomRecipe)recipe.value()).secondaryInput.test(secondaryWeave)) continue;
                ItemStack outputSlot = state.inventory.getStackInSlot(12);
                ItemStack output = ((PowerLoomRecipe)recipe.value()).output.get();
                if (!outputSlot.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)outputSlot, (ItemStack)output) || outputSlot.getCount() + output.getCount() > outputSlot.getMaxStackSize())) continue;
                state.processor.addProcessToQueue(new ATTMultiblockProcess<PowerLoomRecipe>(recipe, i, j), level, false);
                state.lastTexture = ((PowerLoomRecipe)recipe.value()).inProgressTexture;
            }
        }
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (state.processor.getQueue().isEmpty()) {
            if (state.rackDispl < 0.65625f) {
                state.rackDispl = Math.min(0.65625f, state.rackDispl + 0.046875f);
            }
            if (state.rackSideDispl < 0.25f) {
                state.rackSideDispl = Math.min(0.25f, state.rackSideDispl + 0.125f);
            }
            if (state.rack2Displ < 0.4375f) {
                state.rack2Displ = Math.min(0.4375f, state.rack2Displ + 0.0875f);
            }
            if (state.longThreadAngle < 19.0f) {
                state.longThreadAngle = Math.min(19.0f, state.longThreadAngle + 3.8f);
            }
            if (state.shortThreadAngle < 42.0f) {
                state.shortThreadAngle = Math.min(42.0f, state.shortThreadAngle + 8.4f);
            }
            state.pirnAngle = 0.0f;
            state.pirnDisplX = 0.0f;
            state.pirnDisplY = 0.0f;
            state.pirnDisplZ = 0.0f;
            context.requestMasterBESync();
        }
        if (state.active) {
            state.rodAngle = (state.rodAngle + 1.75f) % 360.0f;
            context.requestMasterBESync();
        }
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!state.active) continue;
            int tick = process.processTick;
            int delayedTick = tick - 20;
            if (delayedTick > 0) {
                state.rackDispl = state.rackBool ? Math.max(0.0f, state.rackDispl - 0.046875f) : Math.min(0.65625f, state.rackDispl + 0.046875f);
                if (state.rackDispl <= 0.0f && state.rackBool) {
                    state.rackBool = false;
                } else if (state.rackDispl >= 0.65625f && !state.rackBool) {
                    state.rackBool = true;
                }
            } else if (state.rackDispl < 0.65625f) {
                state.rackDispl = Math.min(0.65625f, state.rackDispl + 0.046875f);
            }
            if (delayedTick / 28 >= 1 && delayedTick % 28 <= 4) {
                if (state.rack2Bool) {
                    state.rack2Displ = Math.max(0.0f, state.rack2Displ - 0.0875f);
                    state.longThreadAngle = Math.max(0.0f, state.longThreadAngle - 3.8f);
                    state.shortThreadAngle = Math.max(0.0f, state.shortThreadAngle - 8.4f);
                } else {
                    state.rack2Displ = Math.min(0.4375f, state.rack2Displ + 0.0875f);
                    state.longThreadAngle = Math.min(19.0f, state.longThreadAngle + 3.8f);
                    state.shortThreadAngle = Math.min(42.0f, state.shortThreadAngle + 8.4f);
                }
                if (state.rack2Displ <= 0.0f && state.rack2Bool) {
                    state.rack2Bool = false;
                } else if (state.rack2Displ >= 0.4375f && !state.rack2Bool) {
                    state.rack2Bool = true;
                }
            }
            state.pirnAngle = tick <= 15 ? 3.0f * (float)tick : 45.0f;
            if (tick > 15 && tick <= 20) {
                state.pirnDisplX = 0.02965f * (float)(tick - 15);
                state.pirnDisplY = 0.046875f * (float)(tick - 15);
            } else {
                state.pirnDisplX = 0.14825f;
                state.pirnDisplY = 0.234375f;
            }
            if (delayedTick % 56 > 10 && delayedTick % 56 <= 18) {
                state.pirnDisplZ = state.pirnBool ? Math.max(0.0f, state.pirnDisplZ - 0.703125f) : Math.min(2.8125f, state.pirnDisplZ + 0.703125f);
                if (state.pirnDisplZ <= 0.0f && state.pirnBool) {
                    state.pirnBool = false;
                } else if (state.pirnDisplZ >= 2.8125f && !state.pirnBool) {
                    state.pirnBool = true;
                }
                state.rackSideDispl = state.rackSideBool ? Math.max(0.0f, state.rackSideDispl - 0.0625f) : Math.min(0.25f, state.rackSideDispl + 0.0625f);
                if (state.rackSideDispl <= 0.0f && state.rackSideBool) {
                    state.rackSideBool = false;
                } else if (state.rackSideDispl >= 0.25f && !state.rackSideBool) {
                    state.rackSideBool = true;
                }
            }
            if (tick <= 15) {
                state.pirnDisplX = 0.0f;
                state.pirnDisplY = 0.0f;
                state.pirnDisplZ = 0.0f;
            }
            if (delayedTick % 56 == 18) {
                state.rackSideDispl = 0.25f;
                state.pirnDisplZ = 0.0f;
            }
            state.pirnDisplX2 = tick <= 20 ? 0.0f : state.rackDispl * state.rackDispl * (3.0f - 2.0f * state.rackDispl) - 0.72625f;
            state.weaveTextureDispl = delayedTick > 0 ? Math.floorDiv(delayedTick + 14, 28) : 0;
            ++process.processTick;
            context.requestMasterBESync();
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> registrar) {
        registrar.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_POS, state -> state.energy);
        registrar.register(Capabilities.ItemHandler.BLOCK, (state, position) -> {
            if (PIRN_IN_POS.equals((Object)position.posInMultiblock())) {
                return state.pirnInputHandler;
            }
            if (WEAVE_IN_POS.contains(position.posInMultiblock())) {
                return state.weaveInputHandler;
            }
            if (OUT_CAP.contains(position)) {
                return state.outputHandler;
            }
            return null;
        });
        registrar.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandlerModifiable)state.inventory, drop);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        if (forType == ShapeType.SELECTION) {
            return PowerLoomSelectionShapes.SHAPE_GETTER;
        }
        return PowerLoomShapes.SHAPE_GETTER;
    }

    public ItemInteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (isClient) {
            return ItemInteractionResult.SUCCESS;
        }
        int bX = posInMultiblock.getX();
        int bY = posInMultiblock.getY();
        int bZ = posInMultiblock.getZ();
        State state = (State)ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        ItemStack heldItem = player.getMainHandItem();
        if (PIRN_IN_POS.equals((Object)posInMultiblock)) {
            IItemHandler insertionHandler = state.pirnInputHandler;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(8);
            for (int i = 0; i < 8; ++i) {
                list.add(state.inventory.getStackInSlot(i));
            }
            boolean areAllEmpty = list.stream().allMatch(ItemStack::isEmpty);
            boolean anyMatch = list.stream().anyMatch(stack -> stack.is(heldItem.getItem()));
            if ((areAllEmpty || anyMatch) && PowerLoomRecipe.isValidPirnInput(level, heldItem)) {
                ItemStack stack2 = heldItem.copyWithCount(1);
                if ((stack2 = ItemHandlerHelper.insertItem((IItemHandler)insertionHandler, (ItemStack)stack2, (boolean)false)).isEmpty()) {
                    heldItem.shrink(1);
                    ctx.markDirtyAndSync();
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if (player.isShiftKeyDown() && state.processor.getQueueSize() < state.processor.getMaxQueueSize()) {
                for (int i = 0; i < 8; ++i) {
                    ItemStack stack3 = state.inventory.getStackInSlot(i);
                    if (stack3.isEmpty()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack3.copy());
                    int size = stack3.getCount();
                    stack3.shrink(size);
                    ctx.markDirtyAndSync();
                    return ItemInteractionResult.SUCCESS;
                }
            }
        } else if (bX == 2 && bY == 0 && (bZ == 1 || bZ == 2 || bZ == 3)) {
            IItemHandler insertionHandler = state.weaveInputHandler;
            for (int i = 8; i < 11; ++i) {
                ItemStack stack4;
                RecipeHolder<PowerLoomRecipe> recipe = PowerLoomRecipe.findRecipeForRendering(level, state.inventory.getStackInSlot(11));
                if (recipe != null && ((PowerLoomRecipe)recipe.value()).inputs.get(0).testIgnoringSize(heldItem)) {
                    if (state.inventory.getStackInSlot(i).isEmpty()) {
                        int size = heldItem.getCount();
                        ItemStack stack5 = heldItem.copyWithCount(size);
                        if ((stack5 = ItemHandlerHelper.insertItem((IItemHandler)insertionHandler, (ItemStack)stack5, (boolean)false)).isEmpty()) {
                            heldItem.shrink(size);
                            ctx.markDirtyAndSync();
                            return ItemInteractionResult.SUCCESS;
                        }
                    }
                    if (state.inventory.getStackInSlot(i).getCount() < state.inventory.getStackInSlot(i).getMaxStackSize()) {
                        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)insertionHandler, (ItemStack)heldItem, (boolean)true);
                        if (remainder.isEmpty()) {
                            int size = heldItem.getCount() - remainder.getCount();
                            ItemHandlerHelper.insertItemStacked((IItemHandler)insertionHandler, (ItemStack)heldItem, (boolean)false);
                            heldItem.shrink(size);
                            ctx.markDirtyAndSync();
                            return ItemInteractionResult.SUCCESS;
                        }
                        int size = remainder.getCount();
                        ItemStack stack6 = heldItem.copyWithCount(size);
                        if ((stack6 = ItemHandlerHelper.insertItem((IItemHandler)insertionHandler, (ItemStack)stack6, (boolean)false)).isEmpty()) {
                            heldItem.shrink(size);
                            ctx.markDirtyAndSync();
                            return ItemInteractionResult.SUCCESS;
                        }
                    }
                }
                if (!player.isShiftKeyDown() || state.processor.getQueueSize() >= state.processor.getMaxQueueSize() || (stack4 = state.inventory.getStackInSlot(i)).isEmpty()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack4.copy());
                int size = stack4.getCount();
                stack4.shrink(size);
                ctx.markDirtyAndSync();
                return ItemInteractionResult.SUCCESS;
            }
        } else if (SECONDARY_WEAVE_IO_POS.equals((Object)posInMultiblock)) {
            if (player.isShiftKeyDown() && state.processor.getQueueSize() < state.processor.getMaxQueueSize()) {
                ItemStack stack7;
                if (state.inventory.getStackInSlot(8).isEmpty() && state.inventory.getStackInSlot(9).isEmpty() && state.inventory.getStackInSlot(10).isEmpty() && !(stack7 = state.inventory.getStackInSlot(11)).isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack7.copy());
                    int size = stack7.getCount();
                    stack7.shrink(size);
                    ctx.markDirtyAndSync();
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                RecipeHolder<PowerLoomRecipe> recipe = PowerLoomRecipe.findRecipeForRendering(ctx.getLevel().getRawLevel(), heldItem);
                if (recipe != null) {
                    ItemStack secondarySlot = state.inventory.getStackInSlot(11);
                    if (secondarySlot.isEmpty()) {
                        int size = Math.min(heldItem.getCount(), ((PowerLoomRecipe)recipe.value()).secondaryInput.getCount());
                        ItemStack stack8 = heldItem.copyWithCount(size);
                        state.inventory.setStackInSlot(11, stack8);
                        heldItem.shrink(size);
                        ctx.markDirtyAndSync();
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (secondarySlot.is(heldItem.getItem()) && secondarySlot.getCount() < ((PowerLoomRecipe)recipe.value()).secondaryInput.getCount()) {
                        int remaining = ((PowerLoomRecipe)recipe.value()).secondaryInput.getCount() - secondarySlot.getCount();
                        int size = Math.min(heldItem.getCount(), remaining);
                        ItemStack stack9 = heldItem.copyWithCount(size);
                        state.inventory.insertItem(11, stack9, false);
                        heldItem.shrink(size);
                        ctx.markDirtyAndSync();
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            }
        } else if (bX == 0 && bY == 0 && (bZ == 1 || bZ == 2 || bZ == 3)) {
            ItemStack stack10;
            if (player.isShiftKeyDown() && !(stack10 = state.inventory.getStackInSlot(12)).isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack10.copy());
                int size = stack10.getCount();
                stack10.shrink(size);
                ctx.markDirtyAndSync();
                return ItemInteractionResult.SUCCESS;
            }
        } else if (ATTConfig.SERVER.enablePowerLoomDebug.get().booleanValue() && player.getMainHandItem().is((Item)ATTItems.PIRN.get())) {
            player.openMenu(ATTContainerTypes.POWER_LOOM.provide(ctx, posInMultiblock));
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static class State
    implements IMultiblockState,
    ATTProcessContext<PowerLoomRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        private final MultiblockProcessor<PowerLoomRecipe, ATTProcessContext<PowerLoomRecipe>> processor;
        public final PowerLoomInventory inventory;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final Supplier<@Nullable IItemHandler> output;
        private final DroppingMultiblockOutput secondaryOutput;
        private final IItemHandler pirnInputHandler;
        private final IItemHandler weaveInputHandler;
        private final IItemHandler outputHandler;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;
        private boolean active;
        public float rodAngle = 0.0f;
        public float rackDispl = 0.0f;
        public float rackSideDispl = 0.0f;
        public float rack2Displ = 0.0f;
        public float longThreadAngle = 0.0f;
        public float shortThreadAngle = 0.0f;
        public float pirnAngle = 0.0f;
        public float pirnDisplX = 0.0f;
        public float pirnDisplX2 = 0.0f;
        public float pirnDisplY = 0.0f;
        public float pirnDisplZ = 0.0f;
        public int weaveTextureDispl = 0;
        public int holderRotation;
        public boolean rackBool = true;
        public boolean rackSideBool = true;
        public boolean rack2Bool = true;
        public boolean pirnBool = true;
        public ResourceLocation lastTexture = ResourceLocation.parse((String)"neoforge:white");

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            @Nullable Supplier getLevel = ctx.levelSupplier();
            List<SlotwiseItemHandler.IOConstraintGroup> constraintGroups = List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.input(arg_0 -> State.lambda$new$0((Supplier)getLevel, arg_0)), 8), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.input(arg_0 -> State.lambda$new$1((Supplier)getLevel, arg_0)), 3), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.ANY_INPUT, 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 1));
            ArrayList<SlotwiseItemHandler.IOConstraint> slotConstraints = new ArrayList<SlotwiseItemHandler.IOConstraint>();
            for (SlotwiseItemHandler.IOConstraintGroup group : constraintGroups) {
                for (int i = 0; i < group.slotCount(); ++i) {
                    slotConstraints.add(group.constraint());
                }
            }
            this.inventory = new PowerLoomInventory(slotConstraints, markDirty);
            this.processor = new MultiblockProcessor(1, 0.0f, 1, markDirty, (arg_0, arg_1) -> PowerLoomRecipe.RECIPES.getById(arg_0, arg_1));
            this.output = ctx.getCapabilityAt(Capabilities.ItemHandler.BLOCK, MAIN_OUT_POS);
            this.secondaryOutput = new DroppingMultiblockOutput(SECONDARY_OUT_POS, ctx);
            this.pirnInputHandler = new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(0, 8));
            this.weaveInputHandler = new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(8, 11));
            this.outputHandler = new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(12, 1));
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.pirnInputHandler, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.weaveInputHandler, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.outputHandler, MachineInterfaceHandler.BASIC_ITEM_OUT), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.writeCommonNBT(nbt, provider);
            nbt.put("energy", this.energy.serializeNBT(provider));
        }

        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.readCommonNBT(nbt, provider);
            this.energy.deserializeNBT(provider, nbt.get("energy"));
        }

        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.writeCommonNBT(nbt, provider);
            nbt.putBoolean("active", this.active);
            nbt.putInt("holderRotation", this.holderRotation);
        }

        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.readCommonNBT(nbt, provider);
            this.active = nbt.getBoolean("active");
            this.holderRotation = nbt.getInt("holderRotation");
        }

        private void writeCommonNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("processor", this.processor.toNBT(provider));
            nbt.put("inventory", (Tag)this.inventory.serializeNBT(provider));
            nbt.putString("lastTexture", this.lastTexture.toString());
        }

        private void readCommonNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.processor.fromNBT(nbt.get("processor"), (getRecipe, data, p) -> new ATTMultiblockProcess(getRecipe, data), provider);
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.lastTexture = nbt.contains("lastTexture", 8) ? ResourceLocation.parse((String)nbt.getString("lastTexture")) : ResourceLocation.parse((String)"neoforge:white");
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        public int[] getOutputSlots() {
            return new int[]{12};
        }

        @Override
        public void doProcessOutput(ItemStack output, IMultiblockLevel level) {
            this.secondaryOutput.insertOrDrop(output, level);
        }

        public void onProcessFinish(MultiblockProcess<PowerLoomRecipe, ?> process, Level level) {
            this.pirnAngle = 0.0f;
            this.holderRotation = (this.holderRotation + 1) % 8;
        }

        public boolean shouldRenderAsActive() {
            return this.active;
        }

        public List<MultiblockProcess<PowerLoomRecipe, ATTProcessContext<PowerLoomRecipe>>> getProcessQueue() {
            return this.processor.getQueue();
        }

        private static /* synthetic */ boolean lambda$new$1(Supplier getLevel, ItemStack stack) {
            return PowerLoomRecipe.isValidWeaveInput((Level)getLevel.get(), stack);
        }

        private static /* synthetic */ boolean lambda$new$0(Supplier getLevel, ItemStack stack) {
            return PowerLoomRecipe.isValidPirnInput((Level)getLevel.get(), stack);
        }
    }

    public static class PowerLoomInventory
    extends ItemStackHandler {
        private final List<SlotwiseItemHandler.IOConstraint> slotConstraints;
        private final Runnable onChanged;

        public PowerLoomInventory(List<SlotwiseItemHandler.IOConstraint> slotConstraints, Runnable onChanged) {
            super(slotConstraints.size());
            this.slotConstraints = slotConstraints;
            this.onChanged = onChanged;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.onChanged.run();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot >= this.slotConstraints.size() || !this.slotConstraints.get(slot).allowInsert().test(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= this.slotConstraints.size() || !this.slotConstraints.get(slot).allowExtract()) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot < 8) {
                return 1;
            }
            return 64;
        }
    }
}

