/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.hermitowo.advancedtfctech.client.ATTSounds;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.ATTMultiblockLogicHelper;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTMultiblockProcess;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTProcessContext;
import com.hermitowo.advancedtfctech.common.multiblocks.shapes.ThresherShapes;
import com.hermitowo.advancedtfctech.common.recipes.ThresherRecipe;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class ThresherLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 1);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(2, 1, 1, RelativeBlockFace.LEFT);
    public static final int FIRST_IN_SLOT = 0;
    public static final int IN_SLOT_COUNT = 6;
    public static final int FIRST_OUT_SLOT = 6;
    public static final int OUT_SLOT_COUNT = 6;
    private static final MultiblockFace MAIN_OUT_POS = new MultiblockFace(1, 0, -1, RelativeBlockFace.FRONT);
    private static final MultiblockFace SECONDARY_OUT_POS = new MultiblockFace(1, 1, 3, RelativeBlockFace.FRONT);
    private static final CapabilityPosition IN_CAP = new CapabilityPosition(1, 2, 1, RelativeBlockFace.UP);
    private static final CapabilityPosition MAIN_OUT_CAP = CapabilityPosition.opposing((MultiblockFace)MAIN_OUT_POS);
    private static final int[] OUTPUT_SLOTS = new int[]{6, 7, 8, 9, 10, 11};
    public static final int NUM_SLOTS = 12;
    public static final int ENERGY_CAPACITY = 32000;

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        boolean active = state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        if (active != state.active) {
            state.active = active;
            context.requestMasterBESync();
        }
        this.enqueueProcesses(state, context.getLevel().getRawLevel());
        if (context.getLevel().shouldTickModulo(8)) {
            ATTMultiblockLogicHelper.sort(state, 6, 6);
            ATTMultiblockLogicHelper.handleItemOutput(state, state.output, OUTPUT_SLOTS);
        }
    }

    private void enqueueProcesses(State state, Level level) {
        if (state.energy.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return;
        }
        int[] usedInvSlots = new int[6];
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!(process instanceof MultiblockProcessInMachine)) continue;
            int[] nArray = ((MultiblockProcessInMachine)process).getInputSlots();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int i2;
                int n2 = i2 = nArray[i];
                usedInvSlots[n2] = usedInvSlots[n2] + 1;
            }
        }
        for (int slot = 0; slot < 6; ++slot) {
            ItemStack stack = state.inventory.getStackInSlot(slot);
            if (stack.getCount() <= usedInvSlots[slot]) continue;
            stack = stack.copy();
            stack.shrink(usedInvSlots[slot]);
            RecipeHolder<ThresherRecipe> recipe = ThresherRecipe.findRecipe(level, stack);
            if (recipe == null) continue;
            state.processor.addProcessToQueue(new ATTMultiblockProcess.ProcessWithItemStackProvider<ThresherRecipe>(recipe, slot), level, false);
        }
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.active, (BooleanSupplier)context.isValid(), (Vec3)soundPos, (Holder)ATTSounds.THRESHER.holder(), (float)0.5f);
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> registrar) {
        registrar.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_POS, state -> state.energy);
        registrar.register(Capabilities.ItemHandler.BLOCK, (state, position) -> {
            if (MAIN_OUT_CAP.equals((Object)position)) {
                return state.outputHandler;
            }
            if (IN_CAP.equals((Object)position)) {
                return state.insertionHandler;
            }
            return null;
        });
        registrar.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandlerModifiable)state.inventory, drop);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return ThresherShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState,
    ATTProcessContext<ThresherRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        private final MultiblockProcessor<ThresherRecipe, ATTProcessContext<ThresherRecipe>> processor;
        public final SlotwiseItemHandler inventory;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final Supplier<@Nullable IItemHandler> output;
        private final DroppingMultiblockOutput secondaryOutput;
        private final IItemHandler insertionHandler;
        private final IItemHandler outputHandler;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;
        private boolean active;
        private BooleanSupplier isPlayingSound = () -> false;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            @Nullable Supplier getLevel = ctx.levelSupplier();
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.input(arg_0 -> State.lambda$new$1((Supplier)getLevel, arg_0)), 6), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 6)), (Runnable)markDirty);
            this.processor = new MultiblockProcessor(1, 0.0f, 1, markDirty, (arg_0, arg_1) -> ThresherRecipe.RECIPES.getById(arg_0, arg_1));
            this.output = ctx.getCapabilityAt(Capabilities.ItemHandler.BLOCK, MAIN_OUT_POS);
            this.secondaryOutput = new DroppingMultiblockOutput(SECONDARY_OUT_POS, ctx);
            this.insertionHandler = new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(0, 6));
            this.outputHandler = new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(6, 12));
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.insertionHandler, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.outputHandler, MachineInterfaceHandler.BASIC_ITEM_OUT), new MachineInterfaceHandler.MachineCheckImplementation((Object)this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("energy", this.energy.serializeNBT(provider));
            nbt.put("processor", this.processor.toNBT(provider));
            nbt.put("inventory", this.inventory.serializeNBT(provider));
        }

        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.energy.deserializeNBT(provider, nbt.get("energy"));
            this.processor.fromNBT(nbt.get("processor"), (getRecipe, data, p) -> new ATTMultiblockProcess.ProcessWithItemStackProvider(getRecipe, data), provider);
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
        }

        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("active", this.active);
        }

        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.active = nbt.getBoolean("active");
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public IItemHandlerModifiable getInventory() {
            return this.inventory.getRawHandler();
        }

        @Override
        public int[] getOutputSlots() {
            return OUTPUT_SLOTS;
        }

        @Override
        public void doProcessOutput(ItemStack output, IMultiblockLevel level) {
            this.secondaryOutput.insertOrDrop(output, level);
        }

        public List<MultiblockProcess<ThresherRecipe, ATTProcessContext<ThresherRecipe>>> getProcessQueue() {
            return this.processor.getQueue();
        }

        private static /* synthetic */ boolean lambda$new$1(Supplier getLevel, ItemStack stack) {
            return ThresherRecipe.findRecipe((Level)getLevel.get(), stack) != null;
        }
    }
}

