/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import com.hermitowo.advancedtfctech.common.multiblocks.process.ATTProcessContext;
import com.hermitowo.advancedtfctech.common.recipes.ATTMultiblockRecipe;
import com.hermitowo.advancedtfctech.common.recipes.IItemStackProviderMultiblockRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ATTMultiblockProcess<R extends MultiblockRecipe>
extends MultiblockProcess<R, ATTProcessContext<R>> {
    protected final int[] inputSlots;
    protected int[] inputAmounts = null;
    protected int[] inputTanks = new int[0];

    public ATTMultiblockProcess(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe, int ... inputSlots) {
        super(recipeId, getRecipe);
        this.inputSlots = inputSlots;
    }

    public ATTMultiblockProcess(RecipeHolder<R> recipe, int ... inputSlots) {
        super(recipe);
        this.inputSlots = inputSlots;
    }

    public ATTMultiblockProcess(BiFunction<Level, ResourceLocation, R> getRecipe, CompoundTag data) {
        super(getRecipe, data);
        this.inputSlots = data.getIntArray("process_inputSlots");
        this.setInputAmounts(data.getIntArray("process_inputAmounts"));
        this.setInputTanks(data.getIntArray("process_inputTanks"));
    }

    public ATTMultiblockProcess<R> setInputTanks(int ... inputTanks) {
        this.inputTanks = inputTanks;
        return this;
    }

    public ATTMultiblockProcess<R> setInputAmounts(int ... inputAmounts) {
        this.inputAmounts = inputAmounts;
        return this;
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    @Nullable
    public int[] getInputAmounts() {
        return this.inputAmounts;
    }

    public int[] getInputTanks() {
        return this.inputTanks;
    }

    protected List<IngredientWithSize> getRecipeItemInputs(ATTProcessContext<R> context, Level level) {
        MultiblockRecipe recipe = this.getLevelData(level).recipe();
        return recipe == null ? List.of() : recipe.getItemInputs();
    }

    protected List<SizedFluidIngredient> getRecipeFluidInputs(ATTProcessContext<R> context, Level level) {
        MultiblockRecipe recipe = this.getLevelData(level).recipe();
        return recipe == null ? List.of() : recipe.getFluidInputs();
    }

    protected boolean canOutputItem(ATTProcessContext<R> context, ItemStack output) {
        int[] outputSlots;
        for (int iOutputSlot : outputSlots = context.getOutputSlots()) {
            IItemHandlerModifiable inv = context.getInventory();
            ItemStack s = inv.getStackInSlot(iOutputSlot);
            if (s.isEmpty()) {
                return true;
            }
            boolean match = ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)output);
            if (!match || s.getCount() + output.getCount() > inv.getSlotLimit(iOutputSlot)) continue;
            return true;
        }
        return false;
    }

    protected boolean canOutputFluid(ATTProcessContext<R> context, FluidStack output) {
        int[] outputTanks;
        IFluidTank[] tanks = context.getInternalTanks();
        for (int iOutputTank : outputTanks = context.getOutputTanks()) {
            if (tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
            return true;
        }
        return false;
    }

    protected void outputFluid(ATTProcessContext<R> context, FluidStack output) {
        int[] outputTanks;
        IFluidTank[] tanks = context.getInternalTanks();
        for (int iOutputTank : outputTanks = context.getOutputTanks()) {
            if (tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
            tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.EXECUTE);
            break;
        }
    }

    protected void outputItem(ATTProcessContext<R> context, ItemStack output, IMultiblockLevel level) {
        int[] outputSlots;
        ATTMultiblockRecipe attRecipe;
        MultiblockRecipe recipe = this.getRecipe(level.getRawLevel());
        if (recipe instanceof ATTMultiblockRecipe && !(attRecipe = (ATTMultiblockRecipe)recipe).getSecondaryOutput().isEmpty()) {
            context.doProcessOutput(attRecipe.getSecondaryOutput(), level);
        }
        for (int iOutputSlot : outputSlots = context.getOutputSlots()) {
            IItemHandlerModifiable inv = context.getInventory();
            ItemStack s = inv.getStackInSlot(iOutputSlot);
            if (s.isEmpty()) {
                inv.setStackInSlot(iOutputSlot, output.copy());
                break;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)output) || s.getCount() + output.getCount() > inv.getSlotLimit(iOutputSlot)) continue;
            s.grow(output.getCount());
            break;
        }
    }

    public void doProcessTick(ATTProcessContext<R> context, IMultiblockLevel level) {
        MultiblockRecipe recipe = this.getLevelData(level.getRawLevel()).recipe();
        if (recipe == null) {
            return;
        }
        IItemHandlerModifiable inv = context.getInventory();
        if (recipe.shouldCheckItemAvailability() && recipe.getItemInputs() != null && inv != null) {
            NonNullList query = NonNullList.withSize((int)this.inputSlots.length, (Object)ItemStack.EMPTY);
            for (int i = 0; i < this.inputSlots.length; ++i) {
                if (this.inputSlots[i] < 0 || this.inputSlots[i] >= inv.getSlots()) continue;
                query.set(i, (Object)context.getInventory().getStackInSlot(this.inputSlots[i]));
            }
            if (!IngredientUtils.stacksMatchIngredientWithSizeList((List)recipe.getItemInputs(), (NonNullList)query)) {
                this.clearProcess = true;
                return;
            }
        }
        super.doProcessTick(context, level);
    }

    protected void processFinish(ATTProcessContext<R> context, IMultiblockLevel level) {
        super.processFinish(context, level);
        IItemHandlerModifiable inv = context.getInventory();
        List<IngredientWithSize> itemInputList = this.getRecipeItemInputs(context, level.getRawLevel());
        if (inv != null && this.inputSlots != null && itemInputList != null) {
            if (this.inputAmounts != null && this.inputSlots.length == this.inputAmounts.length) {
                for (int i = 0; i < this.inputSlots.length; ++i) {
                    if (this.inputAmounts[i] <= 0) continue;
                    inv.getStackInSlot(this.inputSlots[i]).shrink(this.inputAmounts[i]);
                }
            } else {
                block1: for (IngredientWithSize ingr : new ArrayList<IngredientWithSize>(itemInputList)) {
                    int ingrSize = ingr.getCount();
                    for (int slot : this.inputSlots) {
                        if (inv.getStackInSlot(slot).isEmpty() || !ingr.test(inv.getStackInSlot(slot))) continue;
                        int taken = Math.min(inv.getStackInSlot(slot).getCount(), ingrSize);
                        inv.getStackInSlot(slot).shrink(taken);
                        if (inv.getStackInSlot(slot).getCount() <= 0) {
                            inv.setStackInSlot(slot, ItemStack.EMPTY);
                        }
                        if ((ingrSize -= taken) <= 0) continue block1;
                    }
                }
            }
        }
        IFluidTank[] tanks = context.getInternalTanks();
        List<SizedFluidIngredient> fluidInputList = this.getRecipeFluidInputs(context, level.getRawLevel());
        if (tanks != null && this.inputTanks != null && fluidInputList != null) {
            block3: for (SizedFluidIngredient ingr : new ArrayList<SizedFluidIngredient>(fluidInputList)) {
                int ingrSize = ingr.amount();
                for (int tank : this.inputTanks) {
                    if (tanks[tank] == null || !ingr.ingredient().test(tanks[tank].getFluid())) continue;
                    int taken = Math.min(tanks[tank].getFluidAmount(), ingrSize);
                    tanks[tank].drain(taken, IFluidHandler.FluidAction.EXECUTE);
                    if ((ingrSize -= taken) <= 0) continue block3;
                }
            }
        }
    }

    public void writeExtraDataToNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        if (this.inputSlots != null) {
            nbt.putIntArray("process_inputSlots", this.inputSlots);
        }
        if (this.inputAmounts != null) {
            nbt.putIntArray("process_inputAmounts", this.inputAmounts);
        }
        if (this.inputTanks != null) {
            nbt.putIntArray("process_inputTanks", this.inputTanks);
        }
    }

    public static class ProcessWithItemStackProvider<R extends ATTMultiblockRecipe>
    extends ATTMultiblockProcess<R> {
        public ProcessWithItemStackProvider(RecipeHolder<R> recipe, int ... inputSlots) {
            super(recipe, inputSlots);
        }

        public ProcessWithItemStackProvider(BiFunction<Level, ResourceLocation, R> getRecipe, CompoundTag data) {
            super(getRecipe, data);
        }

        protected List<ItemStack> getRecipeItemOutputs(Level level, ATTProcessContext<R> context) {
            ATTMultiblockRecipe recipe = (ATTMultiblockRecipe)this.getRecipe(level);
            if (recipe == null) {
                return NonNullList.create();
            }
            ItemStack input = context.getInventory().getStackInSlot(this.inputSlots[0]);
            return ((IItemStackProviderMultiblockRecipe)((Object)recipe)).generateActualOutput(input);
        }
    }
}

