/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.multiblocks.shapes;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BeamhouseShapes
implements Function<BlockPos, VoxelShape> {
    public static final Function<BlockPos, VoxelShape> SHAPE_GETTER = new BeamhouseShapes();

    private BeamhouseShapes() {
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        int bX = posInMultiblock.getX();
        int bY = posInMultiblock.getY();
        int bZ = posInMultiblock.getZ();
        if (bY == 0) {
            if (bX < 3 && bZ < 3) {
                return BeamhouseShapes.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
            }
            if (bZ == 3) {
                if (bX == 1) {
                    return Shapes.or((VoxelShape)BeamhouseShapes.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), (VoxelShape)BeamhouseShapes.box(8.0, 8.0, 0.0, 16.0, 16.0, 16.0));
                }
                if (bX == 3) {
                    return Shapes.or((VoxelShape)BeamhouseShapes.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), (VoxelShape)BeamhouseShapes.box(0.0, 8.0, 0.0, 8.0, 16.0, 16.0));
                }
            }
            if (bX == 3 && bZ == 2) {
                return Shapes.or((VoxelShape)BeamhouseShapes.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), (VoxelShape[])new VoxelShape[]{BeamhouseShapes.box(10.0, 8.0, 2.0, 14.0, 16.0, 4.0), BeamhouseShapes.box(10.0, 8.0, 12.0, 14.0, 16.0, 14.0)});
            }
        }
        if (bY == 1) {
            if (bZ == 0) {
                if (bX == 0) {
                    return BeamhouseShapes.box(8.0, 6.0, 9.0, 16.0, 18.0, 16.0);
                }
                if (bX == 1 || bX == 2) {
                    return BeamhouseShapes.box(0.0, 6.0, 9.0, 16.0, 18.0, 16.0);
                }
            }
            if (bZ == 2) {
                if (bX == 0) {
                    return Shapes.or((VoxelShape)BeamhouseShapes.box(8.0, 6.0, 0.0, 16.0, 18.0, 7.0), (VoxelShape[])new VoxelShape[]{BeamhouseShapes.box(6.0, 8.0, 11.0, 16.0, 12.0, 15.0), BeamhouseShapes.box(6.0, 8.0, 15.0, 10.0, 12.0, 16.0)});
                }
                if (bX == 1) {
                    return Shapes.or((VoxelShape)BeamhouseShapes.box(0.0, 6.0, 0.0, 16.0, 18.0, 7.0), (VoxelShape[])new VoxelShape[]{BeamhouseShapes.box(4.0, 4.0, 10.0, 12.0, 16.0, 16.0), BeamhouseShapes.box(0.0, 8.0, 11.0, 4.0, 12.0, 15.0)});
                }
                if (bX == 2) {
                    return BeamhouseShapes.box(0.0, 6.0, 0.0, 16.0, 18.0, 7.0);
                }
                if (bX == 3) {
                    return BeamhouseShapes.box(8.0, 0.0, 0.0, 16.0, 16.0, 16.0);
                }
            }
            if (bZ == 1) {
                if (bX == 0) {
                    return Shapes.or((VoxelShape)BeamhouseShapes.box(8.0, 6.0, 0.0, 16.0, 18.0, 16.0), (VoxelShape)BeamhouseShapes.box(6.0, 7.0, 3.0, 8.0, 17.0, 13.0));
                }
                if (bX == 2) {
                    return BeamhouseShapes.box(0.0, 6.0, 0.0, 16.0, 18.0, 16.0);
                }
            }
            if (bZ == 3 && bX == 2) {
                return BeamhouseShapes.box(-8.0, 0.0, 0.0, 24.0, 8.0, 16.0);
            }
        }
        if (bY == 2) {
            if (bZ == 1) {
                if (bX == 0) {
                    return BeamhouseShapes.box(8.0, 2.0, 2.0, 16.0, 11.0, 14.0);
                }
                if (bX == 1 || bX == 2) {
                    return BeamhouseShapes.box(0.0, 2.0, 2.0, 16.0, 11.0, 14.0);
                }
            } else {
                return BeamhouseShapes.box(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return Shapes.block();
    }

    private static VoxelShape box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Shapes.box((double)(minX / 16.0), (double)(minY / 16.0), (double)(minZ / 16.0), (double)(maxX / 16.0), (double)(maxY / 16.0), (double)(maxZ / 16.0));
    }
}

