/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.multiblocks.shapes;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ThresherShapes
implements Function<BlockPos, VoxelShape> {
    public static final Function<BlockPos, VoxelShape> SHAPE_GETTER = new ThresherShapes();

    private ThresherShapes() {
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        int bX = posInMultiblock.getX();
        int bY = posInMultiblock.getY();
        int bZ = posInMultiblock.getZ();
        if (bY == 0) {
            if (bX == 0 && bZ == 1) {
                return Shapes.or((VoxelShape)ThresherShapes.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), (VoxelShape[])new VoxelShape[]{ThresherShapes.box(2.0, 0.0, 12.0, 6.0, 16.0, 14.0), ThresherShapes.box(2.0, 0.0, 2.0, 6.0, 16.0, 4.0)});
            }
            if (bX != 1 || bZ != 0) {
                return ThresherShapes.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
            }
        }
        if (bY == 1) {
            if (bX == 0 && bZ == 0) {
                return ThresherShapes.box(8.0, 0.0, 9.0, 16.0, 14.0, 16.0);
            }
            if (bX == 0 && bZ == 2) {
                return ThresherShapes.box(8.0, 0.0, 0.0, 16.0, 14.0, 7.0);
            }
            if (bX == 2 && bZ == 0) {
                return ThresherShapes.box(0.0, 0.0, 9.0, 8.0, 14.0, 16.0);
            }
            if (bX == 2 && bZ == 2) {
                return ThresherShapes.box(0.0, 0.0, 0.0, 8.0, 14.0, 7.0);
            }
            if (bX == 1) {
                if (bZ == 0) {
                    return ThresherShapes.box(0.0, 0.0, 9.0, 16.0, 14.0, 16.0);
                }
                if (bZ == 2) {
                    return Shapes.or((VoxelShape)ThresherShapes.box(2.0, 2.0, 7.0, 14.0, 14.0, 16.0), (VoxelShape)ThresherShapes.box(0.0, 0.0, 0.0, 16.0, 14.0, 7.0));
                }
            }
        }
        if (bY == 2 && bZ == 1) {
            if (bX == 0) {
                return ThresherShapes.box(8.0, 0.0, 2.0, 16.0, 7.0, 14.0);
            }
            if (bX == 2) {
                return ThresherShapes.box(0.0, 0.0, 2.0, 8.0, 7.0, 14.0);
            }
        }
        return Shapes.block();
    }

    private static VoxelShape box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Shapes.box((double)(minX / 16.0), (double)(minY / 16.0), (double)(minZ / 16.0), (double)(maxX / 16.0), (double)(maxY / 16.0), (double)(maxZ / 16.0));
    }
}

