/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.recipes;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import com.google.common.collect.Lists;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.ATTMultiblockLogic;
import com.hermitowo.advancedtfctech.common.recipes.ATTMultiblockRecipe;
import com.hermitowo.advancedtfctech.common.recipes.ATTRecipeSerializers;
import com.hermitowo.advancedtfctech.common.recipes.ATTRecipeTypes;
import com.hermitowo.advancedtfctech.common.recipes.IItemStackProviderMultiblockRecipe;
import com.hermitowo.advancedtfctech.util.ATTDualCodecs;
import com.hermitowo.advancedtfctech.util.ModifiableSupplier;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeMapCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class BeamhouseRecipe
extends ATTMultiblockRecipe
implements IItemStackProviderMultiblockRecipe {
    public static final CachedRecipeList<BeamhouseRecipe> RECIPES = new CachedRecipeList(ATTRecipeTypes.BEAMHOUSE);
    public static final ModifiableSupplier<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS = ModifiableSupplier.of();
    public final IngredientWithSize input;
    public final SizedFluidIngredient fluidInput;
    public final ItemStackProvider output;

    public BeamhouseRecipe(ItemStackProvider output, IngredientWithSize input, SizedFluidIngredient fluidInput, int time, int energy) {
        super(TagOutput.EMPTY, ATTRecipeTypes.BEAMHOUSE, time, energy, MULTIPLIERS);
        this.output = output;
        this.input = input;
        this.fluidInput = fluidInput;
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.fluidInputList = Lists.newArrayList((Object[])new SizedFluidIngredient[]{this.fluidInput});
        this.providerList = Lists.newArrayList((Object[])new ItemStackProvider[]{this.output});
    }

    public static RecipeHolder<BeamhouseRecipe> findRecipe(Level level, ItemStack stack, FluidStack fluid) {
        if (stack.isEmpty() || fluid.isEmpty()) {
            return null;
        }
        for (RecipeHolder recipe : RECIPES.getRecipes(level)) {
            if (!((BeamhouseRecipe)recipe.value()).matches(stack, fluid)) continue;
            return recipe;
        }
        return null;
    }

    public boolean matches(ItemStack stack, FluidStack fluid) {
        return this.isValidInput(stack) && this.isValidFluidInput(fluid);
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input != null && this.input.test(stack);
    }

    public static boolean isValidRecipeInput(Level level, ItemStack stack) {
        for (RecipeHolder recipe : RECIPES.getRecipes(level)) {
            if (!((BeamhouseRecipe)recipe.value()).isValidInput(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidFluidInput(FluidStack fluid) {
        return this.fluidInput != null && this.fluidInput.test(fluid);
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    protected IERecipeSerializer<BeamhouseRecipe> getIESerializer() {
        return (IERecipeSerializer)ATTRecipeSerializers.BEAMHOUSE_SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> generateActualOutput(ItemStack input) {
        NonNullList actualOutput = NonNullList.withSize((int)this.providerList.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.providerList.size(); ++i) {
            ItemStackProvider provider = (ItemStackProvider)this.providerList.get(i);
            actualOutput.set(i, (Object)provider.getStack(input));
        }
        return actualOutput;
    }

    public static class Serializer
    extends IERecipeSerializer<BeamhouseRecipe> {
        public static final DualMapCodec<RegistryFriendlyByteBuf, BeamhouseRecipe> CODECS = DualCompositeMapCodecs.composite((DualMapCodec)ATTDualCodecs.ITEM_STACK_PROVIDER.fieldOf("result"), r -> r.output, (DualMapCodec)IngredientWithSize.CODECS.fieldOf("input"), r -> r.input, (DualMapCodec)IEDualCodecs.SIZED_FLUID_INGREDIENT.fieldOf("fluid"), r -> r.fluidInput, (DualMapCodec)DualCodecs.INT.fieldOf("time"), MultiblockRecipe::getBaseTime, (DualMapCodec)DualCodecs.INT.fieldOf("energy"), MultiblockRecipe::getBaseEnergy, BeamhouseRecipe::new);

        protected DualMapCodec<RegistryFriendlyByteBuf, BeamhouseRecipe> codecs() {
            return CODECS;
        }

        public ItemStack getIcon() {
            return ATTMultiblockLogic.BEAMHOUSE.iconStack();
        }
    }
}

