/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.recipes;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.ATTMultiblockLogic;
import com.hermitowo.advancedtfctech.common.recipes.ATTMultiblockRecipe;
import com.hermitowo.advancedtfctech.common.recipes.ATTRecipeSerializers;
import com.hermitowo.advancedtfctech.common.recipes.ATTRecipeTypes;
import com.hermitowo.advancedtfctech.util.ModifiableSupplier;
import java.util.List;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeMapCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class PowerLoomRecipe
extends ATTMultiblockRecipe {
    public static final CachedRecipeList<PowerLoomRecipe> RECIPES = new CachedRecipeList(ATTRecipeTypes.POWER_LOOM);
    public static final ModifiableSupplier<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS = ModifiableSupplier.of();
    public final List<IngredientWithSize> inputs;
    public final IngredientWithSize secondaryInput;
    public final TagOutput output;
    public final ItemStack secondaryOutput;
    public final ResourceLocation inProgressTexture;

    public PowerLoomRecipe(TagOutput output, ItemStack secondaryOutput, List<IngredientWithSize> inputs, IngredientWithSize secondaryInput, ResourceLocation inProgressTexture, int time, int energy) {
        super(output, ATTRecipeTypes.POWER_LOOM, time, energy, MULTIPLIERS);
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.inputs = inputs;
        this.secondaryInput = secondaryInput;
        this.inProgressTexture = inProgressTexture;
        this.setInputListWithSizes(Lists.newArrayList(this.inputs));
        this.outputList = new TagOutputList(output);
    }

    @Override
    public ItemStack getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public static RecipeHolder<PowerLoomRecipe> findRecipe(Level level, ItemStack pirn, ItemStack weave) {
        if (pirn.isEmpty() || weave.isEmpty()) {
            return null;
        }
        for (RecipeHolder recipe : RECIPES.getRecipes(level)) {
            if (!((PowerLoomRecipe)recipe.value()).matches(pirn, weave)) continue;
            return recipe;
        }
        return null;
    }

    public static RecipeHolder<PowerLoomRecipe> findRecipeForRendering(Level level, ItemStack secondaryInput) {
        if (secondaryInput.isEmpty()) {
            return null;
        }
        for (RecipeHolder recipe : RECIPES.getRecipes(level)) {
            if (!((PowerLoomRecipe)recipe.value()).isValidSecondaryInput(secondaryInput)) continue;
            return recipe;
        }
        return null;
    }

    public boolean matches(ItemStack pirn, ItemStack weave) {
        return this.isValidPirn(pirn) && this.isValidWeaveWithSize(weave);
    }

    public boolean isValidPirn(ItemStack stack) {
        return this.inputs.get(1) != null && this.inputs.get(1).test(stack);
    }

    public static boolean isValidPirnInput(Level level, ItemStack stack) {
        for (RecipeHolder recipe : RECIPES.getRecipes(level)) {
            if (!((PowerLoomRecipe)recipe.value()).isValidPirn(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidWeave(ItemStack stack) {
        return this.inputs.get(0) != null && this.inputs.get(0).testIgnoringSize(stack);
    }

    public boolean isValidWeaveWithSize(ItemStack stack) {
        return this.inputs.get(0) != null && this.inputs.get(0).test(stack);
    }

    public static boolean isValidWeaveInput(Level level, ItemStack stack) {
        for (RecipeHolder recipe : RECIPES.getRecipes(level)) {
            if (!((PowerLoomRecipe)recipe.value()).isValidWeave(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidSecondaryInput(ItemStack stack) {
        return this.secondaryInput != null && this.secondaryInput.testIgnoringSize(stack);
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    protected IERecipeSerializer<PowerLoomRecipe> getIESerializer() {
        return (IERecipeSerializer)ATTRecipeSerializers.POWER_LOOM_SERIALIZER.get();
    }

    public static class Serializer
    extends IERecipeSerializer<PowerLoomRecipe> {
        public static final DualMapCodec<RegistryFriendlyByteBuf, PowerLoomRecipe> CODECS = DualCompositeMapCodecs.composite((DualMapCodec)TagOutput.CODECS.fieldOf("result"), r -> r.output, (DualMapCodec)DualCodecs.ITEM_STACK.optionalFieldOf("secondary_output", (Object)ItemStack.EMPTY), r -> r.secondaryOutput, (DualMapCodec)IngredientWithSize.CODECS.listOf().fieldOf("inputs"), r -> r.inputs, (DualMapCodec)IngredientWithSize.CODECS.fieldOf("secondary_input"), r -> r.secondaryInput, (DualMapCodec)DualCodecs.RESOURCE_LOCATION.fieldOf("in_progress_texture"), r -> r.inProgressTexture, (DualMapCodec)DualCodecs.INT.fieldOf("time"), MultiblockRecipe::getBaseTime, (DualMapCodec)DualCodecs.INT.fieldOf("energy"), MultiblockRecipe::getBaseEnergy, PowerLoomRecipe::new);

        protected DualMapCodec<RegistryFriendlyByteBuf, PowerLoomRecipe> codecs() {
            return CODECS;
        }

        public ItemStack getIcon() {
            return ATTMultiblockLogic.POWER_LOOM.iconStack();
        }
    }
}

