/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.common.recipes;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.ATTMultiblockLogic;
import com.hermitowo.advancedtfctech.common.recipes.ATTMultiblockRecipe;
import com.hermitowo.advancedtfctech.common.recipes.ATTRecipeSerializers;
import com.hermitowo.advancedtfctech.common.recipes.ATTRecipeTypes;
import com.hermitowo.advancedtfctech.common.recipes.IItemStackProviderMultiblockRecipe;
import com.hermitowo.advancedtfctech.util.ATTDualCodecs;
import com.hermitowo.advancedtfctech.util.ModifiableSupplier;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeMapCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class ThresherRecipe
extends ATTMultiblockRecipe
implements IItemStackProviderMultiblockRecipe {
    public static final CachedRecipeList<ThresherRecipe> RECIPES = new CachedRecipeList(ATTRecipeTypes.THRESHER);
    public static final ModifiableSupplier<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS = ModifiableSupplier.of();
    public final IngredientWithSize input;
    public final ItemStackProvider output;
    public final ItemStack secondaryOutput;

    public ThresherRecipe(ItemStackProvider output, IngredientWithSize input, ItemStack secondaryOutput, int time, int energy) {
        super(TagOutput.EMPTY, ATTRecipeTypes.THRESHER, time, energy, MULTIPLIERS);
        this.output = output;
        this.input = input;
        this.secondaryOutput = secondaryOutput;
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.providerList = Lists.newArrayList((Object[])new ItemStackProvider[]{this.output});
    }

    @Override
    public ItemStack getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public static RecipeHolder<ThresherRecipe> findRecipe(Level level, ItemStack stack) {
        for (RecipeHolder recipe : RECIPES.getRecipes(level)) {
            if (!((ThresherRecipe)recipe.value()).input.test(stack)) continue;
            return recipe;
        }
        return null;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    protected IERecipeSerializer<ThresherRecipe> getIESerializer() {
        return (IERecipeSerializer)ATTRecipeSerializers.THRESHER_SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> generateActualOutput(ItemStack input) {
        NonNullList actualOutput = NonNullList.withSize((int)this.providerList.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.providerList.size(); ++i) {
            ItemStackProvider provider = (ItemStackProvider)this.providerList.get(i);
            actualOutput.set(i, (Object)provider.getStack(input));
        }
        return actualOutput;
    }

    public static class Serializer
    extends IERecipeSerializer<ThresherRecipe> {
        public static final DualMapCodec<RegistryFriendlyByteBuf, ThresherRecipe> CODECS = DualCompositeMapCodecs.composite((DualMapCodec)ATTDualCodecs.ITEM_STACK_PROVIDER.fieldOf("result"), r -> r.output, (DualMapCodec)IngredientWithSize.CODECS.fieldOf("input"), r -> r.input, (DualMapCodec)DualCodecs.ITEM_STACK.optionalFieldOf("secondary_output", (Object)ItemStack.EMPTY), r -> r.secondaryOutput, (DualMapCodec)DualCodecs.INT.fieldOf("time"), MultiblockRecipe::getBaseTime, (DualMapCodec)DualCodecs.INT.fieldOf("energy"), MultiblockRecipe::getBaseEnergy, ThresherRecipe::new);

        protected DualMapCodec<RegistryFriendlyByteBuf, ThresherRecipe> codecs() {
            return CODECS;
        }

        public ItemStack getIcon() {
            return ATTMultiblockLogic.THRESHER.iconStack();
        }
    }
}

