/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.compat.jei;

import com.hermitowo.advancedtfctech.AdvancedTFCTech;
import com.hermitowo.advancedtfctech.client.screen.BeamhouseScreen;
import com.hermitowo.advancedtfctech.client.screen.GristMillScreen;
import com.hermitowo.advancedtfctech.client.screen.ThresherScreen;
import com.hermitowo.advancedtfctech.common.blocks.ATTBlocks;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.ATTMultiblockLogic;
import com.hermitowo.advancedtfctech.common.recipes.ATTRecipeTypes;
import com.hermitowo.advancedtfctech.common.recipes.BeamhouseRecipe;
import com.hermitowo.advancedtfctech.common.recipes.FleshingMachineRecipe;
import com.hermitowo.advancedtfctech.common.recipes.GristMillRecipe;
import com.hermitowo.advancedtfctech.common.recipes.PowerLoomRecipe;
import com.hermitowo.advancedtfctech.common.recipes.ThresherRecipe;
import com.hermitowo.advancedtfctech.compat.jei.BeamhouseRecipeCategory;
import com.hermitowo.advancedtfctech.compat.jei.FleshingMachineRecipeCategory;
import com.hermitowo.advancedtfctech.compat.jei.GristMillRecipeCategory;
import com.hermitowo.advancedtfctech.compat.jei.PowerLoomRecipeCategory;
import com.hermitowo.advancedtfctech.compat.jei.ThresherRecipeCategory;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.dries007.tfc.client.ClientHelpers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class ATTJEIPlugin
implements IModPlugin {
    public static final RecipeType<ThresherRecipe> THRESHER = ATTJEIPlugin.type("thresher", ThresherRecipe.class);
    public static final RecipeType<GristMillRecipe> GRIST_MILL = ATTJEIPlugin.type("grist_mill", GristMillRecipe.class);
    public static final RecipeType<PowerLoomRecipe> POWER_LOOM = ATTJEIPlugin.type("power_loom", PowerLoomRecipe.class);
    public static final RecipeType<BeamhouseRecipe> BEAMHOUSE = ATTJEIPlugin.type("beamhouse", BeamhouseRecipe.class);
    public static final RecipeType<FleshingMachineRecipe> FLESHING_MACHINE = ATTJEIPlugin.type("fleshing_machine", FleshingMachineRecipe.class);

    public ResourceLocation getPluginUid() {
        return AdvancedTFCTech.rl("jei");
    }

    private static <T> RecipeType<T> type(String name, Class<T> tClass) {
        return RecipeType.create((String)"advancedtfctech", (String)name, tClass);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> List<T> recipes(Supplier<net.minecraft.world.item.crafting.RecipeType<T>> type) {
        return ATTJEIPlugin.recipes(type, e -> true);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> List<T> recipes(Supplier<net.minecraft.world.item.crafting.RecipeType<T>> type, Predicate<T> filter) {
        return ClientHelpers.getLevelOrThrow().getRecipeManager().getAllRecipesFor(type.get()).stream().map(RecipeHolder::value).filter(filter).toList();
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        IGuiHelper guiHelper = r.getJeiHelpers().getGuiHelper();
        r.addRecipeCategories(new IRecipeCategory[]{new ThresherRecipeCategory(THRESHER, guiHelper)});
        r.addRecipeCategories(new IRecipeCategory[]{new GristMillRecipeCategory(GRIST_MILL, guiHelper)});
        r.addRecipeCategories(new IRecipeCategory[]{new PowerLoomRecipeCategory(POWER_LOOM, guiHelper)});
        r.addRecipeCategories(new IRecipeCategory[]{new BeamhouseRecipeCategory(BEAMHOUSE, guiHelper)});
        r.addRecipeCategories(new IRecipeCategory[]{new FleshingMachineRecipeCategory(FLESHING_MACHINE, guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration r) {
        r.addRecipes(THRESHER, ATTJEIPlugin.recipes(ATTRecipeTypes.THRESHER));
        r.addRecipes(GRIST_MILL, ATTJEIPlugin.recipes(ATTRecipeTypes.GRIST_MILL));
        r.addRecipes(POWER_LOOM, ATTJEIPlugin.recipes(ATTRecipeTypes.POWER_LOOM));
        r.addRecipes(BEAMHOUSE, ATTJEIPlugin.recipes(ATTRecipeTypes.BEAMHOUSE));
        r.addRecipes(FLESHING_MACHINE, ATTJEIPlugin.recipes(ATTRecipeTypes.FLESHING_MACHINE));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        ATTJEIPlugin.cat(r, ATTMultiblockLogic.THRESHER.block(), THRESHER);
        ATTJEIPlugin.cat(r, ATTMultiblockLogic.GRIST_MILL.block(), GRIST_MILL);
        ATTJEIPlugin.cat(r, ATTMultiblockLogic.POWER_LOOM.block(), POWER_LOOM);
        ATTJEIPlugin.cat(r, ATTMultiblockLogic.BEAMHOUSE.block(), BEAMHOUSE);
        ATTJEIPlugin.cat(r, ATTBlocks.FLESHING_MACHINE, FLESHING_MACHINE);
    }

    private static void cat(IRecipeCatalystRegistration r, Supplier<? extends Block> supplier, RecipeType<?> type) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)supplier.get()), new RecipeType[]{type});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration r) {
        r.addRecipeClickArea(ThresherScreen.class, 77, 54, 22, 17, new RecipeType[]{THRESHER});
        r.addRecipeClickArea(GristMillScreen.class, 77, 54, 22, 17, new RecipeType[]{GRIST_MILL});
        r.addRecipeClickArea(BeamhouseScreen.class, 17, 69, 26, 18, new RecipeType[]{BEAMHOUSE});
    }
}

